/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.io;

import de.mhus.lib.MFile;
import de.mhus.lib.logging.Log;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class Unzip {
    private static Log log = Log.getLog(Unzip.class);

    public static void unzip(File src, File dst, FileFilter filter) throws ZipException, IOException {
        ZipFile zipFile = new ZipFile(src);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) {
                System.err.println("Extracting directory: " + entry.getName());
                new File(entry.getName()).mkdir();
                continue;
            }
            File dstFile = new File(dst, entry.getName());
            if (filter != null && filter.accept(dstFile)) continue;
            log.t("Unzip file: " + entry.getName());
            MFile.copyFile(zipFile.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(dstFile)));
        }
        zipFile.close();
    }
}

