/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.io;

import de.mhus.lib.util.FlatteningIterator;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Iterator;

public class FileListIterator
implements Iterator<File>,
Iterable<File> {
    private final FlatteningIterator<File> flatteningIterator;

    @Override
    public void remove() {
    }

    public FileListIterator(File file, FileFilter filter) {
        this.flatteningIterator = new FlatteningIterator(new FileIterator(file, filter));
    }

    public FileListIterator(File file) {
        this(file, null);
    }

    @Override
    public boolean hasNext() {
        return this.flatteningIterator.hasNext();
    }

    @Override
    public File next() {
        return this.flatteningIterator.next();
    }

    @Override
    public Iterator<File> iterator() {
        return this;
    }

    private static class FileIterator
    implements Iterator<Object> {
        private final Iterator<File> files;
        private final FileFilter filter;

        FileIterator(File file, FileFilter filter) {
            this.files = Arrays.asList(file.listFiles(filter)).iterator();
            this.filter = filter;
        }

        @Override
        public void remove() {
        }

        @Override
        public Object next() {
            File next = this.files.next();
            if (next.isDirectory()) {
                return new FileIterator(next, this.filter);
            }
            return next;
        }

        @Override
        public boolean hasNext() {
            return this.files.hasNext();
        }
    }
}

