/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.form.ui;

import de.mhus.lib.form.MForm;
import de.mhus.lib.form.MFormLayout;
import de.mhus.lib.form.MFormModel;
import de.mhus.lib.form.layout.LComposite;
import de.mhus.lib.form.layout.LField;
import de.mhus.lib.form.layout.LGroup;
import de.mhus.lib.form.layout.LObject;
import de.mhus.lib.form.layout.LPage;
import de.mhus.lib.form.layout.LTabbed;
import de.mhus.lib.form.objects.FBinary;
import de.mhus.lib.form.objects.FBoolean;
import de.mhus.lib.form.objects.FFile;
import de.mhus.lib.form.objects.FHtml;
import de.mhus.lib.form.objects.FNumber;
import de.mhus.lib.form.objects.FObject;
import de.mhus.lib.form.objects.FOptions;
import de.mhus.lib.form.objects.FPassword;
import de.mhus.lib.form.objects.FString;
import de.mhus.lib.form.objects.FStringList;
import de.mhus.lib.form.objects.FTextArea;
import de.mhus.lib.form.ui.UiModel;
import de.mhus.lib.lang.MObject;

public abstract class UiModelBuilder
extends MObject {
    private UiModel model;

    public UiModelBuilder() {
    }

    public UiModelBuilder(MForm target, String schema) throws Exception {
        this.model = new UiModel(target, schema);
    }

    public UiModelBuilder(MFormModel form) {
        this.model = new UiModel(form);
    }

    public UiModel build() {
        MFormLayout layout = this.model.getLayoutModel();
        this.doStart(layout);
        this.createPartControl(layout.getRoot());
        this.doEnd(layout);
        return this.model;
    }

    protected void createPartControl(LComposite list) {
        for (LObject object : list) {
            if (object instanceof LTabbed) {
                this.doTabStart(object);
                for (LObject o : (LComposite)object) {
                    if (!(o instanceof LComposite)) continue;
                    this.doPreTab(object, o);
                    this.createPartControl((LComposite)o);
                    this.doPostTab(object, o);
                }
                this.doTabEnd(object);
                continue;
            }
            if (object instanceof LPage) {
                this.doPageStart(object);
                for (LObject o : (LComposite)object) {
                    if (!(o instanceof LComposite)) continue;
                    this.doPrePage(object, o);
                    this.createPartControl((LComposite)o);
                    this.doPostPage(object, o);
                }
                this.doPageEnd(object);
                continue;
            }
            if (object instanceof LGroup) {
                this.doGroupStart(object);
                this.createPartControl((LComposite)object);
                this.doGroupEnd(object);
                continue;
            }
            if (object instanceof LComposite) {
                this.doCompositeStart(object);
                for (LObject o : (LComposite)object) {
                    if (!(o instanceof LComposite)) continue;
                    this.doPreComposite(object, o);
                    this.createPartControl((LComposite)o);
                    this.doPostComposite(object, o);
                }
                this.doCompositeEnd(object);
                continue;
            }
            if (!(object instanceof LField)) continue;
            FObject[] objs = ((LField)object).getObjects();
            if (objs.length == 1) {
                FObject obj = objs[0];
                if (obj instanceof FFile) {
                    this.doFile((LField)object, obj);
                    continue;
                }
                if (obj instanceof FHtml) {
                    this.doHtml((LField)object, obj);
                    continue;
                }
                if (obj instanceof FTextArea) {
                    this.doTextArea((LField)object, obj);
                    continue;
                }
                if (obj instanceof FOptions) {
                    this.doOptions((LField)object, obj);
                    continue;
                }
                if (obj instanceof FPassword) {
                    this.doPassword((LField)object, obj);
                    continue;
                }
                if (obj instanceof FBoolean) {
                    this.doBoolean((LField)object, obj);
                    continue;
                }
                if (obj instanceof FString) {
                    this.doString((LField)object, obj);
                    continue;
                }
                if (obj instanceof FNumber) {
                    this.doNumber((LField)object, obj);
                    continue;
                }
                if (obj instanceof FStringList) {
                    this.doStringList((LField)object, obj);
                    continue;
                }
                if (obj instanceof FBinary) {
                    this.doBinary((LField)object, obj);
                    continue;
                }
                this.doUnknownField((LField)object, obj);
                continue;
            }
            this.doMultipleField((LField)object);
        }
    }

    protected abstract void doEnd(MFormLayout var1);

    protected abstract void doStart(MFormLayout var1);

    protected abstract void doMultipleField(LField var1);

    protected abstract void doUnknownField(LField var1, FObject var2);

    protected abstract void doStringList(LField var1, FObject var2);

    protected abstract void doNumber(LField var1, FObject var2);

    protected abstract void doString(LField var1, FObject var2);

    protected abstract void doBoolean(LField var1, FObject var2);

    protected abstract void doPassword(LField var1, FObject var2);

    protected abstract void doOptions(LField var1, FObject var2);

    protected abstract void doTextArea(LField var1, FObject var2);

    protected abstract void doHtml(LField var1, FObject var2);

    protected abstract void doFile(LField var1, FObject var2);

    protected abstract void doBinary(LField var1, FObject var2);

    protected abstract void doCompositeEnd(LObject var1);

    protected abstract void doPostComposite(LObject var1, LObject var2);

    protected abstract void doPreComposite(LObject var1, LObject var2);

    protected abstract void doCompositeStart(LObject var1);

    protected abstract void doGroupEnd(LObject var1);

    protected abstract void doGroupStart(LObject var1);

    protected abstract void doPageEnd(LObject var1);

    protected abstract void doPostPage(LObject var1, LObject var2);

    protected abstract void doPrePage(LObject var1, LObject var2);

    protected abstract void doPageStart(LObject var1);

    protected abstract void doTabEnd(LObject var1);

    protected abstract void doPostTab(LObject var1, LObject var2);

    protected abstract void doPreTab(LObject var1, LObject var2);

    protected abstract void doTabStart(LObject var1);

    public void setRawModel(UiModel model) {
        this.model = model;
    }

    public UiModel getModel() {
        return this.model;
    }
}

