/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.form.ui;

import de.mhus.lib.MActivator;
import de.mhus.lib.MSingleton;
import de.mhus.lib.form.FormException;
import de.mhus.lib.form.MForm;
import de.mhus.lib.form.MFormLayout;
import de.mhus.lib.form.MFormModel;
import de.mhus.lib.form.builders.FormLayoutSimpleBuilder;
import de.mhus.lib.form.builders.FormModelBuilder;
import de.mhus.lib.form.ui.UiInput;
import de.mhus.lib.lang.MObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Observer;
import javax.xml.parsers.ParserConfigurationException;

public class UiModel
extends MObject {
    private MFormModel form;
    private MFormLayout layout;
    private LinkedList<UiInput> elements = new LinkedList();
    private Observer descriptionObserver = null;

    public UiModel(MForm target, String schema) throws Exception {
        this(MSingleton.instance().getActivator(), target, schema);
    }

    public UiModel(MActivator activator, MForm target, String schema) throws Exception {
        this(new FormModelBuilder(activator, target, schema).getForm());
    }

    public UiModel(MFormModel form) {
        this.form = form;
        MFormModel model = form;
        if (model.getLayout() == null) {
            try {
                model.setLayout(new FormLayoutSimpleBuilder(model));
            }
            catch (ParserConfigurationException e) {
                this.log().e(e);
            }
        }
        this.layout = model.getLayout();
    }

    public MFormModel getFormModel() {
        return this.form;
    }

    public MFormLayout getLayoutModel() {
        return this.layout;
    }

    public List<UiInput> getElements() {
        return this.elements;
    }

    public void transferToForm() {
        for (UiInput x : this.elements) {
            try {
                x.setValue();
            }
            catch (FormException e) {
                this.log().d(x, e);
            }
        }
    }

    public void transferToUI() {
        for (UiInput x : this.elements) {
            try {
                x.getValue();
            }
            catch (FormException e) {
                this.log().d(x, e);
            }
        }
    }

    public void dispose() {
        for (UiInput inp : this.elements) {
            inp.dispose();
        }
    }

    public void fireDescriptionChanged(boolean error, String msg) {
        if (this.descriptionObserver != null) {
            try {
                if (!error) {
                    this.descriptionObserver.update(null, msg);
                }
            }
            catch (Throwable t) {
                this.log().w(t);
            }
        }
    }

    public Observer getDescriptionObserver() {
        return this.descriptionObserver;
    }

    public void setDescriptionObserver(Observer descriptionObserver) {
        this.descriptionObserver = descriptionObserver;
    }

    public static interface DescriptionListener {
        public void descriptionChanged(boolean var1, String var2);
    }
}

