/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.form.objects;

import de.mhus.lib.config.IConfig;
import de.mhus.lib.form.FormException;
import de.mhus.lib.form.MFormModel;
import de.mhus.lib.form.ValidateException;
import de.mhus.lib.form.objects.FObject;

public class FString
extends FObject {
    private String value;
    private String defaultValue;
    private int min = 0;
    private int max = 0;

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) throws FormException {
        if (value == null) {
            value = "";
        }
        if (value.length() < this.min) {
            throw new ValidateException((Object)this.getTarget(), (FObject)this, "min");
        }
        if (this.max > 0 && value.length() > this.max) {
            throw new ValidateException((Object)this.getTarget(), (FObject)this, "max");
        }
        if (this.value != null && !this.value.equals(value) || value != null && !value.equals(this.value)) {
            this.value = value;
            this.setChanged(true);
        }
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public Object getFormValue() {
        return this.getValue();
    }

    @Override
    protected Class<?> getFormValueClass() {
        return String.class;
    }

    @Override
    protected void setFormValue(Object value) throws FormException {
        if (value == null) {
            this.setValue(null);
        } else {
            this.setValue(String.valueOf(value));
        }
    }

    public void setMin(int min) {
        this.min = min;
    }

    public int getMin() {
        return this.min;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public int getMax() {
        return this.max;
    }

    @Override
    public void initWithConfig(MFormModel form2, IConfig config) throws FormException {
        this.setValue(config.getString("value", ""));
        this.setMin(config.getInt("min", 0));
        this.setMax(config.getInt("max", 0));
    }
}

