/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.form.objects;

import de.mhus.lib.form.FormException;
import de.mhus.lib.form.IFormDynamic;
import de.mhus.lib.form.objects.FObject;
import de.mhus.lib.form.objects.FString;
import de.mhus.lib.form.objects.IDynOptionsProvider;

public class FOptions
extends FString {
    private IDynOptionsProvider dataProvider;
    private String[] optionValues;
    private String[] optionTitles;

    public void setValue(int nr) throws FormException {
        if (nr < 0 || this.optionValues == null || nr >= this.optionValues.length) {
            this.setValue(null);
            return;
        }
        this.setValue(this.optionValues[nr]);
    }

    public int getValueNr() {
        if (this.optionValues == null) {
            return -1;
        }
        for (int i = 0; i < this.optionValues.length; ++i) {
            if (!this.optionValues[i].equals(this.getValue())) continue;
            return i;
        }
        return -1;
    }

    public String[] getOptionValues() {
        return this.optionValues;
    }

    public void setOptionValues(String[] optionValues) {
        this.optionValues = optionValues;
    }

    public String[] getOptionTitles() {
        return this.optionTitles;
    }

    public void setOptionTitles(String[] optionTitles) {
        this.optionTitles = optionTitles;
    }

    @Override
    public void loadFromTarget() {
        super.loadFromTarget();
        this.loadOptionsData();
    }

    protected void loadOptionsData() {
        this.dataProvider = null;
        try {
            if (this.getTarget() instanceof IFormDynamic) {
                this.setOptionValues((String[])((IFormDynamic)this.getTarget()).getFormValue(this.getName() + ".values"));
                this.setOptionTitles((String[])((IFormDynamic)this.getTarget()).getFormValue(this.getName() + ".titles"));
                return;
            }
        }
        catch (Throwable e) {
            this.log().w(this.getName(), "Managed", e);
            return;
        }
        if (this.dataProvider == null) {
            try {
                this.dataProvider = (IDynOptionsProvider)this.getTarget().getClass().getMethod("get" + this.getNameAsMethodSuffix() + "DataProvider", new Class[0]).invoke((Object)this.getTarget(), new Object[0]);
            }
            catch (Throwable e) {
                this.log().w(this.getName(), e);
            }
        }
        if (this.dataProvider != null) {
            this.setOptionValues(this.dataProvider.getOptionValues());
            this.setOptionTitles(this.dataProvider.getOptionTitles());
            this.log().d(this.getName(), this.optionValues, this.optionTitles);
        }
    }

    @Override
    public void fireChanged(FObject obj, FObject.WHAT_CHANGED what) {
        if (what == FObject.WHAT_CHANGED.TARGET) {
            this.loadOptionsData();
        }
        super.fireChanged(obj, what);
    }
}

