/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.form.objects;

import de.mhus.lib.MEventHandler;
import de.mhus.lib.MString;
import de.mhus.lib.config.IConfig;
import de.mhus.lib.form.FormException;
import de.mhus.lib.form.IFormDynamic;
import de.mhus.lib.form.MForm;
import de.mhus.lib.form.MFormModel;
import de.mhus.lib.form.ValidateException;
import de.mhus.lib.lang.MObject;
import de.mhus.lib.util.MNls;
import java.lang.reflect.InvocationTargetException;
import java.util.regex.Pattern;

public abstract class FObject
extends MObject {
    private String description;
    private String title;
    private boolean writeable = true;
    private Object userObject;
    private String name;
    private boolean changed;
    private boolean enabled = true;
    private String help = null;
    private boolean error = false;
    private MEventHandler<Listener> eventHandler = new MEventHandler();
    private MFormModel form;
    private String currentError;
    private String ruleRegex;
    private String ruleError;
    private String id;
    private int sortId;
    private Pattern rulePattern;

    public void initialize(MFormModel pForm) {
        this.form = pForm;
    }

    public MFormModel getForm() {
        return this.form;
    }

    protected void setChanged(boolean in) {
        if (in == this.changed) {
            return;
        }
        this.changed = in;
        this.fireChanged(this, WHAT_CHANGED.VALUE);
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setCurrentError(String in) {
        if (MString.equals(in, this.currentError)) {
            return;
        }
        this.currentError = in;
        this.fireChanged(this, WHAT_CHANGED.RULE_ERROR);
    }

    public String findCurrentError() {
        return this.currentError;
    }

    public void fireChanged(FObject obj, WHAT_CHANGED what) {
        Object[] list;
        for (Object item : list = this.eventHandler.getListenersArray()) {
            try {
                ((Listener)item).formChangedEvent(obj, what);
            }
            catch (Exception e) {
                this.log().info(e);
            }
        }
        if (this.getForm() != null) {
            this.getForm().fireChanged(obj, what);
        }
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public String getDescription() {
        return this.description;
    }

    public String findDescription() {
        if (this.getNls() == null) {
            return this.description;
        }
        String ask = this.description;
        if (ask == null) {
            ask = this.name + ".description=";
        }
        return this.getNls().find(ask);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTitle() {
        return this.title;
    }

    public String findTitle() {
        String out;
        if (this.getNls() == null) {
            return this.title;
        }
        String ask = this.title;
        if (ask == null) {
            ask = this.name + ".title=[" + this.name + "]";
        }
        if ((out = this.getNls().find(ask)) == null) {
            return this.title == null ? "[title]" : this.title;
        }
        return out;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String findHelp() {
        if (this.getNls() == null) {
            return this.help;
        }
        String ask = this.help;
        if (ask == null) {
            ask = this.name + ".help=";
        }
        return this.getNls().getString(ask, null);
    }

    public boolean isWriteable() {
        return this.writeable;
    }

    public void setWriteable(boolean writeable) {
        if (this.writeable == writeable) {
            return;
        }
        this.writeable = writeable;
        this.fireChanged(this, WHAT_CHANGED.WRITEABLE);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected String getNameAsMethodSuffix() {
        return this.name.substring(0, 1).toUpperCase() + this.name.substring(1);
    }

    protected abstract void setFormValue(Object var1) throws FormException;

    public abstract Object getFormValue();

    protected abstract Class<?> getFormValueClass();

    public void loadFromTarget() {
        try {
            if (this.getTarget() instanceof IFormDynamic) {
                this.setFormValue(((IFormDynamic)this.getTarget()).getFormValue(this.getName()));
                this.setChanged(false);
                this.setError(false);
                return;
            }
        }
        catch (Throwable e) {
            this.log().w(this.getName(), " Managed", e.toString());
            return;
        }
        try {
            this.setFormValue(this.getTarget().getClass().getMethod((this.getFormValueClass() == Boolean.TYPE ? "is" : "get") + this.getNameAsMethodSuffix(), new Class[0]).invoke((Object)this.getTarget(), new Object[0]));
            this.setChanged(false);
            this.setError(false);
        }
        catch (Throwable e) {
            this.log().w(this.getName(), e.toString());
        }
    }

    public void saveToTarget(boolean force) throws FormException {
        if (!force && !this.isChanged()) {
            return;
        }
        if (!this.validateRule()) {
            this.setError(true);
            this.setCurrentError(this.ruleError);
            return;
        }
        if (this.getTarget() instanceof IFormDynamic) {
            try {
                ((IFormDynamic)this.getTarget()).setFormValue(this.getName(), this.getFormValue());
                this.setChanged(false);
                this.setError(false);
                return;
            }
            catch (ValidateException e) {
                this.setError(true);
                this.setCurrentError(e.findMessage());
            }
            catch (Throwable e) {
                this.setError(true);
                throw new FormException(this.getTarget(), this, "set" + this.getNameAsMethodSuffix(), e);
            }
        }
        try {
            this.getTarget().getClass().getMethod("set" + this.getNameAsMethodSuffix(), this.getFormValueClass()).invoke((Object)this.getTarget(), this.getFormValue());
            this.setChanged(false);
            this.setError(false);
        }
        catch (InvocationTargetException e) {
            Throwable f = e.getCause();
            if (f != null && f instanceof ValidateException) {
                this.setError(true);
                this.setCurrentError(((ValidateException)f).findMessage());
            }
            this.setError(true);
            throw new FormException(this.getTarget(), this, "set" + this.getNameAsMethodSuffix(), e);
        }
        catch (Throwable e) {
            this.setError(true);
            throw new FormException(this.getTarget(), this, "set" + this.getNameAsMethodSuffix(), e);
        }
    }

    public boolean validateRule() {
        if (this.rulePattern == null) {
            return true;
        }
        Object value = this.getFormValue();
        if (value == null) {
            return false;
        }
        return this.rulePattern.matcher(value.toString()).find();
    }

    public boolean isEnabled() {
        if (!this.enabled) {
            return false;
        }
        return this.form == null || this.form.isLocalEnabled();
    }

    public boolean isLocalEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        this.fireChanged(this, WHAT_CHANGED.ENABLED);
    }

    public String getHelp() {
        return this.help;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public boolean isError() {
        return this.error;
    }

    public void setError(boolean error) {
        if (this.error == error) {
            return;
        }
        this.error = error;
        this.fireChanged(this, WHAT_CHANGED.ERROR);
    }

    public MEventHandler<Listener> getChangeHandler() {
        return this.eventHandler;
    }

    public boolean isRuleError() {
        return this.currentError != null;
    }

    public boolean isValide(boolean checkWarnings) {
        return (!this.isEnabled() || !this.isRuleError()) && !this.isError();
    }

    public MNls getNls() {
        if (this.form != null) {
            return this.form.getNls();
        }
        return null;
    }

    public void fireStatusEvents() {
        this.fireChanged(this, WHAT_CHANGED.ENABLED);
        this.fireChanged(this, WHAT_CHANGED.ERROR);
        this.fireChanged(this, WHAT_CHANGED.RULE_ERROR);
    }

    public MForm getTarget() {
        return this.form.getTarget();
    }

    public void setId(String in) {
        this.id = in;
    }

    public String getId() {
        return this.id;
    }

    public void setSortId(int sort) {
        this.sortId = sort;
    }

    public int getSortId() {
        return this.sortId;
    }

    public void initWithConfig1(MFormModel form2, IConfig config) throws FormException {
        this.setDescription(config.getString("description", null));
        this.setName(config.getString("name", null));
        this.setId(config.getString("id", null));
        this.setTitle(config.getString("title", null));
        this.setHelp(config.getString("help", null));
        this.setRulePattern(config.getString("rule_pattern", null));
        this.setRuleError(config.getString("rule_error", null));
        this.initWithConfig(form2, config);
    }

    public abstract void initWithConfig(MFormModel var1, IConfig var2) throws FormException;

    public void setRulePattern(String pattern) {
        this.ruleRegex = pattern;
        this.rulePattern = null;
        if (!MString.isEmpty(this.ruleRegex)) {
            this.rulePattern = Pattern.compile(this.ruleRegex);
        }
    }

    public String getRulePattern() {
        return this.ruleRegex;
    }

    public void setRuleError(String ruleError) {
        this.ruleError = ruleError;
    }

    public String getRuleError() {
        return this.ruleError;
    }

    public String toString() {
        return this.getFormValueClass().getSimpleName() + " " + this.getName() + "=" + this.getFormValue();
    }

    public void fireEnabledChanged() {
        this.fireChanged(this, WHAT_CHANGED.ENABLED);
    }

    public static interface Listener {
        public void formChangedEvent(FObject var1, WHAT_CHANGED var2);
    }

    public static enum WHAT_CHANGED {
        VALUE,
        ENABLED,
        RULE_ERROR,
        ERROR,
        WRITEABLE,
        OTHER,
        TARGET;

    }
}

