/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.form.objects;

import de.mhus.lib.config.IConfig;
import de.mhus.lib.form.FormException;
import de.mhus.lib.form.MFormModel;
import de.mhus.lib.form.objects.FObject;

public class FNumber
extends FObject {
    private Number value;
    private Class<?> clazz;
    private String type;
    private Number min = null;
    private Number max = null;
    private Number steps = null;

    @Override
    protected void setFormValue(Object value) throws FormException {
        try {
            if (value == null || value.toString().length() == 0) {
                this.value = new Double(this.min.doubleValue());
            } else if (value instanceof Number) {
                this.value = (Number)value;
            } else {
                value = Double.parseDouble(value.toString());
            }
        }
        catch (Throwable e) {
            this.value = new Double(this.min.doubleValue());
        }
    }

    @Override
    public Object getFormValue() {
        if (this.value == null) {
            this.value = this.min;
        }
        if (this.clazz == Integer.TYPE) {
            return this.value.intValue();
        }
        if (this.clazz == Long.TYPE) {
            return this.value.longValue();
        }
        if (this.clazz == Double.TYPE) {
            return this.value.doubleValue();
        }
        if (this.clazz == Float.TYPE) {
            return Float.valueOf(this.value.floatValue());
        }
        return this.value;
    }

    @Override
    protected Class<?> getFormValueClass() {
        return this.clazz;
    }

    public Number getMinimum() {
        return this.min;
    }

    public Number getMaximum() {
        return this.max;
    }

    public Number getSteps() {
        return this.steps;
    }

    public Number getValue() {
        return this.value;
    }

    public void setValue(Number in) {
        if (in == null) {
            return;
        }
        this.value = in;
    }

    @Override
    public void initWithConfig(MFormModel form2, IConfig config) throws FormException {
        this.clazz = Number.class;
        this.type = config.getName();
        if (this.type == null) {
            this.type = config.getString("type", "number");
        }
        if (config.getName().equals("number")) {
            this.clazz = Number.class;
        } else if (config.getName().equals("integer")) {
            this.clazz = Integer.TYPE;
        } else if (config.getName().equals("long")) {
            this.clazz = Long.TYPE;
        } else if (config.getName().equals("double")) {
            this.clazz = Double.TYPE;
        } else if (config.getName().equals("float")) {
            this.clazz = Float.TYPE;
        }
        this.min = new Double(0.0);
        this.max = new Double(2.147483647E9);
        this.steps = null;
        if (config.isProperty("min")) {
            this.min = new Double(config.getDouble("min", 0.0));
        }
        if (config.isProperty("max")) {
            this.max = new Double(config.getDouble("max", 0.0));
        }
        if (config.isProperty("steps")) {
            this.steps = new Double(config.getDouble("steps", 0.0));
        }
    }
}

