/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.form.objects;

import de.mhus.lib.MCast;
import de.mhus.lib.MDate;
import de.mhus.lib.config.IConfig;
import de.mhus.lib.form.FormException;
import de.mhus.lib.form.MFormModel;
import de.mhus.lib.form.objects.FObject;
import java.util.Date;

public class FDate
extends FObject {
    private Date value;
    private Date defaultValue = null;

    public Date getValue() {
        return this.value;
    }

    public void setValue(Date value) {
        if (value == null && this.value == null || value != null && this.value != null && value.equals(this.value)) {
            return;
        }
        this.value = value;
        this.setChanged(true);
    }

    @Override
    public Object getFormValue() {
        return this.getValue();
    }

    @Override
    protected Class<?> getFormValueClass() {
        return Date.class;
    }

    @Override
    protected void setFormValue(Object value) {
        if (value == null) {
            this.setValue(this.defaultValue);
        }
        if (value instanceof Date) {
            this.setValue((Date)value);
        }
        this.setValue(MCast.toDate(value.toString(), this.defaultValue));
    }

    @Override
    public void initWithConfig(MFormModel form2, IConfig config) throws FormException {
        try {
            MDate date = config.getDate("value");
            this.setValue(date.toDate());
        }
        catch (Throwable t) {
            this.setValue(this.defaultValue);
        }
    }
}

