/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.form.builders;

import de.mhus.lib.MActivator;
import de.mhus.lib.MString;
import de.mhus.lib.config.IConfig;
import de.mhus.lib.config.XmlConfig;
import de.mhus.lib.form.MForm;
import de.mhus.lib.form.MFormModel;
import de.mhus.lib.form.annotations.Form;
import de.mhus.lib.form.annotations.FormAspect;
import de.mhus.lib.form.annotations.FormElement;
import de.mhus.lib.form.annotations.FormLayout;
import de.mhus.lib.form.annotations.FormSortId;
import de.mhus.lib.form.builders.FormElementRegistry;
import de.mhus.lib.form.builders.FormLayoutBuilder;
import de.mhus.lib.form.builders.FormLayoutSimpleBuilder;
import de.mhus.lib.form.objects.FObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FormModelBuilder
extends MFormModel {
    public static final String DEFAULT_SCHEMA = "";
    private SAXParser parser;
    private ElementHandler elementHandler;
    private Element root;
    private Document doc;
    private FormElementRegistry registry;
    private String schema = "";

    public FormModelBuilder(MActivator activator, MForm target, String schema) throws Exception {
        super(activator, target);
        if (schema == null) {
            schema = DEFAULT_SCHEMA;
        }
        this.schema = schema;
        this.parser = SAXParserFactory.newInstance().newSAXParser();
        this.elementHandler = new ElementHandler();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        this.doc = factory.newDocumentBuilder().newDocument();
        this.root = this.doc.createElement("form");
        this.doc.appendChild(this.root);
        this.registry = (FormElementRegistry)this.getActivator().getObject(MFormModel.ELEMENT_REGISTRY);
        this.parseClass();
        this.parseElements(DEFAULT_SCHEMA, this.getTarget());
        this.parseLayout();
        this.root = null;
        this.elementHandler = null;
        this.parser = null;
        this.doc = null;
        this.registry = null;
        this.loadFromTarget();
    }

    private void parseLayout() throws ParserConfigurationException, SAXException, IOException {
        FormLayout layout = this.getTarget().getClass().getAnnotation(FormLayout.class);
        if (layout != null) {
            String xml = layout.value();
            if (!xml.startsWith("<")) {
                xml = "<layout " + xml + "/>";
            }
            this.elementHandler.setBaseElement(this.doc, this.root);
            this.parser.parse((InputStream)new ByteArrayInputStream(xml.getBytes()), (DefaultHandler)this.elementHandler);
            Element out = this.elementHandler.first;
            if (out != null) {
                this.setLayout(new FormLayoutBuilder((MFormModel)this, new XmlConfig(out)));
                return;
            }
        }
        this.setLayout(new FormLayoutSimpleBuilder(this));
    }

    private IConfig fillElement(String prefix, Method method, String xml) throws SAXException, IOException {
        if (!xml.startsWith("<")) {
            xml = "<" + xml + "/>";
        }
        Element out = null;
        this.elementHandler.setBaseElement(this.doc, this.root);
        this.parser.parse((InputStream)new ByteArrayInputStream(xml.getBytes()), (DefaultHandler)this.elementHandler);
        out = this.elementHandler.first;
        if (method != null && method.getName().startsWith("set")) {
            String name = method.getName();
            name = name.substring(3, 4).toLowerCase() + name.substring(4);
            out.setAttribute("name", name);
            out.setAttribute("id", prefix + name);
        }
        return new XmlConfig(out);
    }

    private void parseElements(String prefix, MForm target) throws Exception {
        for (Method method : target.getClass().getMethods()) {
            FormAspect aspect = method.getAnnotation(FormAspect.class);
            FormElement element = method.getAnnotation(FormElement.class);
            Form form = method.getAnnotation(Form.class);
            if (form != null) {
                for (FormElement e : form.value()) {
                    if (!this.schema.equals(e.schema())) continue;
                    element = e;
                    break;
                }
            }
            if (aspect != null) {
                String aspectName = aspect.value();
                MForm innerTarget = (MForm)method.invoke((Object)target, new Object[0]);
                if (innerTarget == null) continue;
                this.parseElements(prefix + aspectName + ".", innerTarget);
                continue;
            }
            if (element == null) continue;
            FormSortId idx = method.getAnnotation(FormSortId.class);
            IConfig xmlElement = this.fillElement(prefix, method, this.toXmlString(element, method.getName()));
            FObject next = this.createModelObjectFromXml(xmlElement, target);
            if (next != null && element.sort() >= 0) {
                next.setSortId(element.sort());
                continue;
            }
            if (next == null || idx == null) continue;
            next.setSortId(idx.value());
        }
    }

    protected String toXmlString(FormElement element, String methodName) {
        if (!MString.isEmpty(element.value())) {
            return element.value();
        }
        return element.type().name().toLowerCase() + " title='" + element.title() + "' nls='" + methodName.toLowerCase() + "'";
    }

    private FObject createModelObjectFromXml(IConfig item, MForm target) throws Exception {
        FObject next = this.registry.createElement(this, item);
        if (next != null) {
            this.getList().add(next);
            next.initialize(this);
        }
        return next;
    }

    private void parseClass() throws SAXException, IOException {
        FormElement annotation = this.getTarget().getClass().getAnnotation(FormElement.class);
        if (annotation != null) {
            ClassHandler handler = new ClassHandler();
            String xml = annotation.value();
            if (!xml.startsWith("<")) {
                xml = "<panel " + xml + "/>";
            }
            this.parser.parse((InputStream)new ByteArrayInputStream(xml.getBytes()), (DefaultHandler)handler);
        }
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    class ClassHandler
    extends DefaultHandler {
        ClassHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String n = attributes.getQName(i);
                String v = attributes.getValue(i);
                if ("title".equals(n)) {
                    FormModelBuilder.this.setTitle(v);
                    continue;
                }
                if ("name".equals(n)) {
                    FormModelBuilder.this.setName(v);
                    continue;
                }
                if (!"resource".equals(n)) continue;
                try {
                    FormModelBuilder.this.setResourceName(v);
                    continue;
                }
                catch (Exception e) {
                    FormModelBuilder.this.log().w(e);
                }
            }
        }
    }

    class ElementHandler
    extends DefaultHandler {
        private Document doc;
        private Element current;
        private Element first;

        ElementHandler() {
        }

        public void setBaseElement(Document doc, Element rules) {
            this.doc = doc;
            this.current = rules;
            this.first = null;
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            Element next = this.doc.createElement(name);
            for (int i = 0; i < attributes.getLength(); ++i) {
                next.setAttribute(attributes.getQName(i), attributes.getValue(i));
            }
            if (this.first == null) {
                this.first = next;
            }
            this.current.appendChild(next);
            this.current = next;
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            this.current = (Element)this.current.getParentNode();
        }
    }
}

