/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.form.builders;

import de.mhus.lib.MXml;
import de.mhus.lib.config.IConfig;
import de.mhus.lib.config.XmlConfig;
import de.mhus.lib.form.MFormLayout;
import de.mhus.lib.form.MFormModel;
import de.mhus.lib.form.layout.LComposite;
import de.mhus.lib.form.layout.LField;
import de.mhus.lib.form.layout.LGroup;
import de.mhus.lib.form.layout.LObject;
import de.mhus.lib.form.layout.LPage;
import de.mhus.lib.form.layout.LTabbed;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class FormLayoutBuilder
extends MFormLayout {
    public FormLayoutBuilder(MFormModel model, IConfig layout) {
        this(model);
        this.load(layout, this.root);
    }

    protected FormLayoutBuilder(MFormModel model) {
        super(model);
    }

    public FormLayoutBuilder(MFormModel model, String resource) throws ParserConfigurationException, SAXException, IOException {
        this(model);
        String res = model.getTarget().getClass().getCanonicalName().replace('.', '/');
        int pos = res.lastIndexOf(47);
        if (pos > 0) {
            res = res.substring(0, pos + 1);
        }
        res = res + resource;
        InputStream is = model.getTarget().getClass().getClassLoader().getResourceAsStream(res);
        XmlConfig document = new XmlConfig(MXml.loadXml(is).getDocumentElement());
        this.load(document, this.root);
    }

    protected void load(IConfig layout, LComposite composite) {
        for (IConfig element : layout.getConfigBundle("element")) {
            LObject next = null;
            String type = element.getString("type", "field");
            if (type.equals("field")) {
                next = new LField();
            } else if (type.equals("page")) {
                next = new LPage();
                this.load(element, (LComposite)next);
            } else if (type.equals("tabbed")) {
                next = new LTabbed();
                this.load(element, (LComposite)next);
                for (IConfig element2 : element.getConfigBundle("element")) {
                    LComposite next2 = new LComposite();
                    next2.setConfig(element2);
                    next2.setModel(this, this.model);
                    ((LComposite)next).add(next2);
                    this.load(element2, next2);
                }
            } else if (type.equals("group")) {
                next = new LGroup();
                this.load(element, (LComposite)next);
            }
            if (next == null) continue;
            next.setModel(this, this.model);
            next.setConfig(element);
            next.init();
            composite.add(next);
        }
    }
}

