/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.form.builders;

import de.mhus.lib.config.IConfig;
import de.mhus.lib.form.MFormModel;
import de.mhus.lib.form.objects.FBinary;
import de.mhus.lib.form.objects.FBoolean;
import de.mhus.lib.form.objects.FDate;
import de.mhus.lib.form.objects.FEMail;
import de.mhus.lib.form.objects.FFile;
import de.mhus.lib.form.objects.FHidden;
import de.mhus.lib.form.objects.FHtml;
import de.mhus.lib.form.objects.FNumber;
import de.mhus.lib.form.objects.FObject;
import de.mhus.lib.form.objects.FOptions;
import de.mhus.lib.form.objects.FPassword;
import de.mhus.lib.form.objects.FTextArea;
import de.mhus.lib.form.objects.FTextField;
import java.util.HashMap;
import java.util.Map;

public class FormElementRegistry {
    protected static Map<String, Class<?>> registry = new HashMap();

    public FObject createElement(MFormModel form, IConfig config) throws Exception {
        return this.createElement(form, config.getName(), config);
    }

    public FObject createElement(MFormModel form, String name, IConfig config) throws Exception {
        Class<?> clazz = registry.get(name);
        FObject element = null;
        element = clazz == null ? (FObject)form.getActivator().createObject(name) : (FObject)form.getActivator().createObject(clazz.getCanonicalName());
        element.initWithConfig1(form, config);
        return element;
    }

    static {
        registry.put("input", FTextField.class);
        registry.put("text", FTextField.class);
        registry.put("textfield", FTextField.class);
        registry.put("textarea", FTextArea.class);
        registry.put("checkbox", FBoolean.class);
        registry.put("boolean", FBoolean.class);
        registry.put("password", FPassword.class);
        registry.put("email", FEMail.class);
        registry.put("select", FOptions.class);
        registry.put("area", FTextArea.class);
        registry.put("file", FFile.class);
        registry.put("hidden", FHidden.class);
        registry.put("html", FHtml.class);
        registry.put("number", FNumber.class);
        registry.put("integer", FNumber.class);
        registry.put("double", FNumber.class);
        registry.put("long", FNumber.class);
        registry.put("float", FNumber.class);
        registry.put("date", FDate.class);
        registry.put("binary", FBinary.class);
        registry.put("object", FBinary.class);
    }
}

