/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.form;

import de.mhus.lib.MActivator;
import de.mhus.lib.config.IConfig;
import de.mhus.lib.form.FormException;
import de.mhus.lib.form.MForm;
import de.mhus.lib.form.MFormLayout;
import de.mhus.lib.form.builders.FormElementRegistry;
import de.mhus.lib.form.objects.FGroup;
import de.mhus.lib.form.objects.FObject;
import de.mhus.lib.form.objects.ObjectList;
import de.mhus.lib.resources.MResources;
import de.mhus.lib.util.MNls;
import java.util.Collection;
import java.util.TreeMap;

public class MFormModel
extends FObject {
    public static final String ELEMENT_REGISTRY = FormElementRegistry.class.getCanonicalName();
    private ObjectList list = new ObjectList();
    private MActivator activator;
    private MFormLayout layout;
    private MNls properties;
    private MResources resourceProvider;
    private MForm target;

    public MFormModel(MActivator activator, MForm target) {
        this.activator = activator;
        this.setTarget(target);
    }

    public void setTarget(MForm target) {
        this.target = target;
        for (FObject f : this.list) {
            f.fireChanged(this, FObject.WHAT_CHANGED.TARGET);
        }
        this.fireChanged(this, FObject.WHAT_CHANGED.TARGET);
    }

    @Override
    public MForm getTarget() {
        return this.target;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.isLocalEnabled() == enabled) {
            return;
        }
        super.setEnabled(enabled);
        for (FObject f : this.list) {
            f.fireEnabledChanged();
        }
    }

    public ObjectList getList() {
        return this.list;
    }

    @Override
    public Object getFormValue() {
        return null;
    }

    @Override
    protected Class<?> getFormValueClass() {
        return null;
    }

    @Override
    protected void setFormValue(Object value) {
    }

    public void setLayout(MFormLayout formLayout) {
        this.layout = formLayout;
    }

    public MFormLayout getLayout() {
        return this.layout;
    }

    public FObject getElement(String elementName) {
        if (elementName.equals("@")) {
            return this;
        }
        String[] parts = elementName.split("/");
        return this.getElement(parts, 0, this.list);
    }

    private FObject getElement(String[] elementName, int pos, ObjectList l) {
        if (pos + 1 >= elementName.length) {
            return l.getByName(elementName[pos]);
        }
        return this.getElement(elementName, pos + 1, ((FGroup)l.getByName(elementName[pos])).getList());
    }

    @Override
    public boolean isValide(boolean checkWarnings) {
        if (!super.isValide(checkWarnings)) {
            return false;
        }
        for (FObject f : this.list) {
            if (f.isValide(checkWarnings)) continue;
            return false;
        }
        return true;
    }

    public MActivator getActivator() {
        return this.activator;
    }

    public MResources getResourceProvider() {
        return this.resourceProvider;
    }

    public void setResourceProvider(MResources in) {
        this.resourceProvider = in;
    }

    public void setResourceName(String resourceName) throws Exception {
        this.properties = this.resourceProvider == null ? new MNls(this.getActivator(), this.getTarget().getClass(), resourceName) : new MNls(this.getResourceProvider(), this.getTarget().getClass(), resourceName);
    }

    public void setResourceBundle(MNls res) {
        this.properties = res;
    }

    @Override
    public synchronized MNls getNls() {
        if (this.properties == null) {
            try {
                this.setResourceName(null);
            }
            catch (Exception e) {
                this.log().i(e);
            }
        }
        return this.properties;
    }

    @Override
    public void fireStatusEvents() {
        super.fireStatusEvents();
        for (FObject f : this.list) {
            f.fireStatusEvents();
        }
    }

    public Collection<FObject> getSortedList() {
        TreeMap<Integer, FObject> sorted = new TreeMap<Integer, FObject>();
        for (FObject object : this.getList()) {
            int id = object.getSortId();
            while (sorted.containsKey(id)) {
                ++id;
            }
            sorted.put(id, object);
        }
        return sorted.values();
    }

    @Override
    public void initWithConfig(MFormModel form2, IConfig config) throws FormException {
    }

    @Override
    public void loadFromTarget() {
        for (FObject object : this.getList()) {
            object.loadFromTarget();
        }
    }

    @Override
    public void saveToTarget(boolean force) throws FormException {
        for (FObject object : this.getList()) {
            object.saveToTarget(force);
        }
    }

    @Override
    public String toString() {
        return this.list != null ? this.list.toString() : "?";
    }

    public static enum TYPE {
        TEXT,
        TEXTAREA,
        PASSWORD,
        BOOLEAN,
        SELECT,
        EMAIL,
        FILE,
        HTML,
        HIDDEN,
        DATE,
        NUMBER,
        BINARY;

    }

    public static enum RULE_ACTION {
        ERROR,
        WARN,
        DISABLE;

    }
}

