/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.form;

import de.mhus.lib.MException;
import de.mhus.lib.MSingleton;
import de.mhus.lib.config.IConfig;
import de.mhus.lib.form.FormException;
import de.mhus.lib.form.IConfigurable;
import de.mhus.lib.form.IFormDynamic;
import de.mhus.lib.form.MFormModel;
import de.mhus.lib.form.builders.FormElementRegistry;
import de.mhus.lib.form.builders.FormLayoutSimpleBuilder;
import de.mhus.lib.form.objects.FObject;
import de.mhus.lib.form.objects.ObjectList;
import de.mhus.lib.lang.MObject;
import javax.xml.parsers.ParserConfigurationException;

public class ConfigForm
extends MObject
implements IFormDynamic,
IConfigurable {
    private IConfig config;

    public ConfigForm(IConfig config) {
        this.config = config;
    }

    @Override
    public void setFormValue(String name, Object value) throws FormException {
        try {
            this.config.setProperty(name, String.valueOf(value));
        }
        catch (MException mException) {
            // empty catch block
        }
    }

    @Override
    public Object getFormValue(String name) throws FormException {
        return this.config.getString(name, "");
    }

    @Override
    public void validateFormAttribute(String name, Class<?> class1) throws FormException {
    }

    @Override
    public MFormModel getConfigurationForm() throws FormException {
        FormElementRegistry registry = new FormElementRegistry();
        MFormModel model = new MFormModel(MSingleton.instance().getActivator(), this);
        ObjectList list = model.getList();
        for (String key : this.config.getPropertyKeys()) {
            this.log().t("key", key);
            try {
                IConfig elementConfig = this.config.getConfig("element_" + key);
                if (elementConfig == null) continue;
                this.log().t("accept fobject", key);
                FObject element = registry.createElement(model, elementConfig.getString("type", "input"), elementConfig);
                element.setName(key);
                element.setTitle(key);
                list.add(element);
            }
            catch (Exception e) {
                this.log().i(key, e);
            }
        }
        try {
            model.setLayout(new FormLayoutSimpleBuilder(model));
        }
        catch (ParserConfigurationException e) {
            this.log().i(e);
        }
        return model;
    }
}

