/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.console;

import de.mhus.lib.console.Console;

public class ConsoleProgressBar {
    int len = 0;
    long max = 0L;
    long current = 0L;
    long start = -1L;
    long stop = -1L;
    Console stream;

    public ConsoleProgressBar(Console console) {
        this(console, 0, 100L);
    }

    public ConsoleProgressBar(Console console, long _max) {
        this(console, 0, _max);
    }

    public ConsoleProgressBar(Console console, int _len, long _max) {
        this.stream = console;
        if (_len < 1) {
            _len = console.getWidth();
        }
        this.len = _len;
        this.max = _max;
    }

    public void add(long _add) {
        this.set(this.current + _add);
    }

    public void set(long _current) {
        if (this.stop != -1L) {
            return;
        }
        if (this.start == -1L) {
            this.start = System.currentTimeMillis();
            this.paintHeader();
        }
        if (_current > this.max) {
            _current = this.max;
        }
        if (_current < 0L) {
            _current = 0L;
        }
        if (_current < this.current) {
            this.clean();
        }
        this.paint(_current);
    }

    public void clean() {
        if (this.stop != -1L) {
            return;
        }
        this.current = 0L;
        this.stream.cr();
        for (int i = 0; i < this.len; ++i) {
            this.stream.print(' ');
        }
        this.stream.cr();
    }

    private void paintHeader() {
        for (int i = 0; i < this.len; ++i) {
            if (i == 0 || i == this.len - 1) {
                this.stream.print('|');
                continue;
            }
            if (i % 10 == 0) {
                this.stream.print('+');
                continue;
            }
            this.stream.print('-');
        }
        this.stream.println();
    }

    private void paint(long _current) {
        int old = (int)((double)this.len / (double)this.max * (double)this.current);
        int new_ = (int)((double)this.len / (double)this.max * (double)_current);
        int diff = new_ - old;
        for (int i = 0; i < diff; ++i) {
            this.stream.print('*');
        }
        this.current = _current;
    }

    public void finish() {
        this.stream.println();
        this.stop = System.currentTimeMillis();
    }

    public long getTime() {
        if (this.stop == -1L) {
            return (System.currentTimeMillis() - this.start) / 1000L;
        }
        return (this.stop - this.start) / 1000L;
    }

    public float getRate() {
        long time = this.getTime();
        if (time == 0L) {
            return this.current;
        }
        return (float)this.current / (float)time;
    }
}

