/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.config;

import de.mhus.lib.MException;
import de.mhus.lib.MXml;
import de.mhus.lib.config.XmlConfig;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;

public class XmlConfigFile
extends XmlConfig {
    private File file;

    public XmlConfigFile(File file) throws FileNotFoundException, Exception {
        if (file.exists()) {
            this.readConfig(new FileReader(file));
        }
        this.file = file;
    }

    @Override
    public boolean canSave() {
        if (!this.file.exists()) {
            return this.file.getParentFile().canWrite();
        }
        return this.file.canWrite();
    }

    @Override
    public void save() throws MException {
        try {
            if (!this.canSave()) {
                return;
            }
            log.t("save config", this);
            FileOutputStream os = new FileOutputStream(this.file);
            MXml.trim(this.element);
            MXml.saveXml(this.element, os);
            os.close();
        }
        catch (Exception e) {
            throw new MException(new Object[]{e});
        }
    }

    public String toString() {
        return this.getClass() + ": " + this.file.getAbsolutePath();
    }

    public void setName(String name) {
        this.name = name;
    }

    public File getFile() {
        return this.file;
    }
}

