/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.config;

import de.mhus.lib.MException;
import de.mhus.lib.config.PropertiesConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class PropertiesConfigFile
extends PropertiesConfig {
    private File file;

    public PropertiesConfigFile(File file) throws IOException {
        if (file.exists()) {
            FileInputStream fis = new FileInputStream(file);
            this.properties.load(fis);
            fis.close();
        }
        this.file = file;
    }

    @Override
    public boolean canSave() {
        return this.file.canWrite();
    }

    @Override
    public void save() throws MException {
        try {
            if (!this.canSave()) {
                return;
            }
            log.t("save config", this);
            FileOutputStream os = new FileOutputStream(this.file);
            this.properties.store(os, "");
            os.close();
        }
        catch (Exception e) {
            throw new MException(new Object[]{e});
        }
    }

    public String toString() {
        return this.getClass() + ": " + this.file.getAbsolutePath();
    }

    public void setName(String name) {
        this.name = name;
    }

    public File getFile() {
        return this.file;
    }
}

