/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.config;

import de.mhus.lib.MCast;
import de.mhus.lib.MException;
import de.mhus.lib.config.IConfig;
import de.mhus.lib.config.IConfigRoot;
import de.mhus.lib.config.IFlatConfig;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Properties;

public class PropertiesConfig
extends IConfig
implements IConfigRoot,
IFlatConfig {
    protected Properties properties = null;
    protected boolean changed = false;
    protected String name;

    public PropertiesConfig() {
        this(new Properties());
    }

    public PropertiesConfig(Properties config) {
        this.properties = config;
    }

    public PropertiesConfig(String fill) {
        this.properties = new Properties();
        if (fill != null) {
            try {
                this.readConfig(new StringReader(fill));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void writeConfig(Writer os) throws IOException {
        this.properties.store(os, "");
        this.changed = false;
    }

    @Override
    public void readConfig(Reader file) throws IOException {
        this.properties.load(file);
    }

    public void configRemoved() {
    }

    @Override
    public IConfig getConfig(String key) {
        return null;
    }

    @Override
    public IConfig[] getConfigBundle(String key) {
        return new IConfig[0];
    }

    @Override
    public IConfig[] getConfigBundle() {
        return new IConfig[0];
    }

    @Override
    public String[] getConfigKeys() {
        return new String[0];
    }

    @Override
    public String[] getPropertyKeys() {
        return this.properties.keySet().toArray(new String[this.properties.size()]);
    }

    @Override
    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    @Override
    public boolean isProperty(String name) {
        return this.properties.containsKey(name);
    }

    @Override
    public void removeProperty(String key) {
        this.properties.remove(key);
        this.changed = true;
    }

    @Override
    public void setProperty(String key, Object value) {
        this.properties.setProperty(key, MCast.objectToString(value));
        this.changed = true;
    }

    @Override
    public boolean isConfigChanged() {
        return this.changed;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IConfig createConfig(String key) throws MException {
        throw new MException(new Object[]{"not supported"});
    }

    @Override
    public int moveConfig(IConfig config, int newPos) throws MException {
        throw new MException(new Object[]{"not supported"});
    }

    @Override
    public void removeConfig(IConfig config) throws MException {
        throw new MException(new Object[]{"not supported"});
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public IConfig getParent() {
        return null;
    }
}

