/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.config;

import de.mhus.lib.MFile;
import de.mhus.lib.MString;
import de.mhus.lib.MXml;
import de.mhus.lib.config.DirConfig;
import de.mhus.lib.config.HashConfig;
import de.mhus.lib.config.IConfig;
import de.mhus.lib.config.JsonConfig;
import de.mhus.lib.config.JsonConfigFile;
import de.mhus.lib.config.PropertiesConfig;
import de.mhus.lib.config.PropertiesConfigFile;
import de.mhus.lib.config.XmlConfig;
import de.mhus.lib.config.XmlConfigFile;
import de.mhus.lib.util.Rfc1738;
import java.io.File;

public class MConfigFactory {
    protected MConfigFactory instance = null;

    public static synchronized MConfigFactory getInstance() {
        return new MConfigFactory();
    }

    public IConfig createConfigFor(File file) throws Exception {
        if (file == null) {
            return null;
        }
        if (file.isDirectory()) {
            return new DirConfig(file);
        }
        String key = file.getName();
        if (key.endsWith(".xml")) {
            XmlConfigFile out = new XmlConfigFile(file);
            out.setName(MFile.getFileNameOnly(key));
            return out;
        }
        if (key.endsWith(".properties")) {
            PropertiesConfigFile out = new PropertiesConfigFile(file);
            out.setName(MFile.getFileNameOnly(key));
            return out;
        }
        if (key.endsWith(".json")) {
            JsonConfigFile out = new JsonConfigFile(file);
            out.setName(MFile.getFileNameOnly(key));
            return out;
        }
        return null;
    }

    public IConfig createConfigForFile(String key) throws Exception {
        if (key == null) {
            return null;
        }
        if (key.endsWith(".xml")) {
            return new XmlConfig();
        }
        if (key.endsWith(".properties")) {
            return new PropertiesConfig();
        }
        if (key.endsWith(".json")) {
            return new JsonConfig();
        }
        return null;
    }

    public IConfig toConfig(String configString) throws Exception {
        if (MString.isEmptyTrim(configString)) {
            return new HashConfig();
        }
        if (configString.startsWith("[") || configString.startsWith("{")) {
            return new JsonConfig(configString);
        }
        if (configString.startsWith("<?")) {
            return new XmlConfig(MXml.loadXml(configString).getDocumentElement());
        }
        if (configString.contains("=")) {
            if (configString.contains("&")) {
                return new HashConfig(Rfc1738.explode(configString));
            }
            return new PropertiesConfig(configString);
        }
        return null;
    }
}

