/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.config;

import de.mhus.lib.MException;
import de.mhus.lib.MFile;
import de.mhus.lib.config.JsonConfig;
import java.io.File;
import java.io.FileOutputStream;

public class JsonConfigFile
extends JsonConfig {
    private File file;

    public JsonConfigFile(File file) throws Exception {
        super(MFile.readFile(file));
        this.file = file;
    }

    @Override
    public boolean canSave() {
        return this.file.canWrite();
    }

    @Override
    public void save() throws MException {
        try {
            if (!this.canSave()) {
                return;
            }
            log.t("save config", this);
            FileOutputStream os = new FileOutputStream(this.file);
            this.write(os);
            os.close();
        }
        catch (Exception e) {
            throw new MException(new Object[]{e});
        }
    }

    public String toString() {
        return this.getClass() + ": " + this.file.getAbsolutePath();
    }

    public void setName(String name) {
        this.name = name;
    }

    public File getFile() {
        return this.file;
    }
}

