/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.config;

import de.mhus.lib.MCast;
import de.mhus.lib.MException;
import de.mhus.lib.config.HashConfig;
import de.mhus.lib.config.IConfig;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.node.TextNode;

public class JsonConfig
extends IConfig {
    private ObjectNode node;
    protected String name;
    private IConfig parent;

    public JsonConfig(String json) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode nodex = (JsonNode)mapper.readValue(json, JsonNode.class);
        if (nodex instanceof ObjectNode) {
            this.node = (ObjectNode)nodex;
        } else {
            this.node = ((ArrayNode)nodex).objectNode();
            this.node.put("default", nodex);
        }
    }

    public JsonConfig(ObjectNode node) {
        this(null, null, node);
    }

    public JsonConfig(String name, IConfig parent, ObjectNode node) {
        this.node = node;
        this.name = name;
        this.parent = parent;
    }

    public JsonConfig() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        this.node = (ObjectNode)mapper.readValue("{}", JsonNode.class);
    }

    public JsonConfig(String name2, JsonConfig jsonConfig, TextNode textNode) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        this.node = (ObjectNode)mapper.readValue("{}", JsonNode.class);
        this.node.put("_", (JsonNode)textNode);
    }

    @Override
    public IConfig getConfig(String name) {
        JsonNode child = this.node.get(name);
        if (child == null || !child.isArray() || child.size() < 1) {
            return null;
        }
        return new JsonConfig(name, (IConfig)this, (ObjectNode)((ArrayNode)child).get(0));
    }

    @Override
    public IConfig[] getConfigBundle(String name) {
        JsonNode child = this.node.get(name);
        if (child == null || !child.isArray()) {
            return new IConfig[0];
        }
        IConfig[] out = new IConfig[child.size()];
        for (int i = 0; i < child.size(); ++i) {
            JsonNode obj = child.get(i);
            if (obj instanceof ObjectNode) {
                out[i] = new JsonConfig(name, (IConfig)this, (ObjectNode)child.get(i));
                continue;
            }
            if (!(obj instanceof TextNode)) continue;
            try {
                out[i] = new JsonConfig(name, this, (TextNode)child.get(i));
                continue;
            }
            catch (Exception e) {
                log.d(name, e);
            }
        }
        return out;
    }

    @Override
    public IConfig[] getConfigBundle() {
        LinkedList<JsonConfig> out = new LinkedList<JsonConfig>();
        for (JsonNode child : this.node) {
            if (child == null || !child.isArray()) continue;
            for (int i = 0; i < child.size(); ++i) {
                out.add(new JsonConfig(this.name, (IConfig)this, (ObjectNode)child.get(i)));
            }
        }
        if (out == null || out.size() == 0) {
            return new IConfig[0];
        }
        return out.toArray(new HashConfig[out.size()]);
    }

    @Override
    public String[] getConfigKeys() {
        LinkedList<String> out = new LinkedList<String>();
        Iterator i = this.node.getFieldNames();
        while (i.hasNext()) {
            String name = (String)i.next();
            JsonNode child = this.node.get(name);
            if (!child.isArray()) continue;
            out.add(name);
        }
        return out.toArray(new String[out.size()]);
    }

    @Override
    public Object getProperty(String name) {
        JsonNode child = this.node.get(name);
        if (child == null) {
            return null;
        }
        return child.getValueAsText();
    }

    @Override
    public String[] getPropertyKeys() {
        LinkedList<String> out = new LinkedList<String>();
        Iterator i = this.node.getFieldNames();
        while (i.hasNext()) {
            String name = (String)i.next();
            JsonNode child = this.node.get(name);
            if (child.isArray()) continue;
            out.add(name);
        }
        return out.toArray(new String[out.size()]);
    }

    @Override
    public boolean isProperty(String name) {
        JsonNode child = this.node.get(name);
        return child != null && !child.isArray();
    }

    @Override
    public void removeProperty(String name) {
        this.getNode().remove(name);
    }

    @Override
    public void setProperty(String name, Object value) {
        this.getNode().put(name, MCast.objectToString(value));
    }

    public ObjectNode getNode() {
        return this.node;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IConfig createConfig(String key) throws MException {
        ArrayNode array;
        if (this.node.get(key) != null && !this.node.get(key).isArray()) {
            this.node.remove(key);
        }
        if ((array = (ArrayNode)this.node.get(key)) == null) {
            array = this.node.arrayNode();
            this.node.put(key, (JsonNode)array);
        }
        if (!(array instanceof ArrayNode)) {
            throw new MException(new Object[]{key + " is not an array"});
        }
        ObjectNode out = array.objectNode();
        array.add((JsonNode)out);
        return new JsonConfig(key, (IConfig)this, out);
    }

    @Override
    public int moveConfig(IConfig config, int newPos) throws MException {
        if (!(config instanceof JsonConfig)) {
            throw new MException(new Object[]{"not JsonConfig"});
        }
        JsonNode array = this.node.get(config.getName());
        if (array == null) {
            throw new MException(new Object[]{"config set not found"});
        }
        int pos = this.findPosOf((ArrayNode)array, (JsonConfig)config);
        if (pos < 0) {
            throw new MException(new Object[]{"could not find child"});
        }
        if (((ArrayNode)array).size() == 1) {
            if (newPos == -102 || newPos == -103 || newPos == 0) {
                return 0;
            }
            throw new MException(new Object[]{"out of range"});
        }
        if (newPos == -102) {
            ((ArrayNode)array).remove(pos);
            ((ArrayNode)array).insert(0, (JsonNode)((JsonConfig)config).node);
            return 0;
        }
        if (newPos == -103) {
            ((ArrayNode)array).remove(pos);
            ((ArrayNode)array).add((JsonNode)((JsonConfig)config).node);
            return ((ArrayNode)array).size() - 1;
        }
        if (newPos == -101) {
            if (pos == ((ArrayNode)array).size() - 1) {
                throw new MException(new Object[]{"out of range"});
            }
            ((ArrayNode)array).remove(pos);
            ((ArrayNode)array).insert(pos + 1, (JsonNode)((JsonConfig)config).node);
            return pos + 1;
        }
        if (newPos == -100) {
            if (pos == 0) {
                throw new MException(new Object[]{"out of range"});
            }
            ((ArrayNode)array).remove(pos);
            ((ArrayNode)array).insert(pos - 1, (JsonNode)((JsonConfig)config).node);
            return pos - 1;
        }
        if (pos == newPos) {
            return pos;
        }
        ((ArrayNode)array).remove(pos);
        ((ArrayNode)array).insert(newPos, (JsonNode)((JsonConfig)config).node);
        return newPos;
    }

    @Override
    public void removeConfig(IConfig config) throws MException {
        if (!(config instanceof JsonConfig)) {
            return;
        }
        JsonNode array = this.node.get(config.getName());
        if (array == null) {
            return;
        }
        int pos = this.findPosOf((ArrayNode)array, (JsonConfig)config);
        if (pos < 0) {
            throw new MException(new Object[]{"could not find child"});
        }
        ((ArrayNode)array).remove(pos);
    }

    protected int findPosOf(ArrayNode array, JsonConfig config) {
        int cnt = 0;
        for (JsonNode item : array) {
            if (item == config.node) {
                return cnt;
            }
            ++cnt;
        }
        return -1;
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public IConfig getParent() {
        return this.parent;
    }

    public void write(OutputStream os) throws IOException {
        ObjectMapper m = new ObjectMapper();
        m.writeValue(os, (Object)this.node);
    }

    public void write(Writer os) throws IOException {
        ObjectMapper m = new ObjectMapper();
        m.writeValue(os, (Object)this.node);
    }
}

