/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.config;

import de.mhus.lib.config.IConfig;
import de.mhus.lib.config.IConfigRoot;
import de.mhus.lib.util.ImmutableCollection;
import java.util.Collection;
import java.util.Map;

public abstract class IConfigProvider {
    private Map<String, IConfig> configList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IConfig getConfig(String key) throws Exception {
        IConfigProvider iConfigProvider = this;
        synchronized (iConfigProvider) {
            IConfig out = this.configList.get(key);
            if (out == null && (out = this.createConfig(key)) != null) {
                this.configList.put(key, out);
            }
            return out;
        }
    }

    protected abstract IConfig createConfig(String var1) throws Exception;

    public abstract boolean isWriteable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() {
        if (!this.isWriteable()) {
            return;
        }
        IConfigProvider iConfigProvider = this;
        synchronized (iConfigProvider) {
            for (Map.Entry<String, IConfig> config : this.configList.entrySet()) {
                IConfigRoot root;
                if (!(config.getValue() instanceof IConfigRoot) || !(root = (IConfigRoot)((Object)config.getValue())).isConfigChanged()) continue;
                this.writeConfiguration(config.getKey(), root);
            }
        }
    }

    protected abstract void writeConfiguration(String var1, IConfigRoot var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getLoadedKeys() {
        IConfigProvider iConfigProvider = this;
        synchronized (iConfigProvider) {
            return new ImmutableCollection<String>(this.configList.keySet());
        }
    }
}

