/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.config;

import de.mhus.lib.IProperties;
import de.mhus.lib.MException;
import de.mhus.lib.MString;
import de.mhus.lib.logging.Log;
import de.mhus.lib.parser.CompiledString;
import de.mhus.lib.parser.DefaultScriptPart;
import de.mhus.lib.parser.StringCompiler;
import de.mhus.lib.parser.StringPart;
import de.mhus.lib.util.ArraySet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class IConfig
extends IProperties {
    protected static Log log = Log.getLog(IConfig.class);
    public static final int MOVE_UP = -100;
    public static final int MOVE_DOWN = -101;
    public static final int MOVE_FIRST = -102;
    public static final int MOVE_LAST = -103;
    private Object userObject = null;
    private ConfigStringCompiler compiler;
    private HashMap<String, CompiledString> compiledCache;

    public abstract String[] getPropertyKeys();

    public abstract IConfig getConfig(String var1);

    public abstract IConfig[] getConfigBundle();

    public abstract IConfig[] getConfigBundle(String var1);

    public abstract String[] getConfigKeys();

    public abstract String getName();

    public abstract IConfig createConfig(String var1) throws MException;

    public abstract int moveConfig(IConfig var1, int var2) throws MException;

    public abstract void removeConfig(IConfig var1) throws MException;

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public String getExtracted(String key) {
        return this.getExtracted(key, null);
    }

    public String getExtracted(String key, String def) {
        return this.getExtracted(key, def, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getExtracted(String key, String def, int level) {
        if (level > 10) {
            return def;
        }
        String value = this.getString(key, null);
        if (value == null) {
            return def;
        }
        if (value.indexOf(36) < 0) {
            return value;
        }
        IConfig iConfig = this;
        synchronized (iConfig) {
            CompiledString cached;
            if (this.compiler == null) {
                this.compiler = new ConfigStringCompiler();
                this.compiledCache = new HashMap();
            }
            if ((cached = this.compiledCache.get(key)) == null) {
                cached = this.compiler.compileString(value);
                this.compiledCache.put(key, cached);
            }
            return cached.execute(level == 0 ? null : new ConfigMap(level));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setString(String name, String value) throws MException {
        IConfig iConfig = this;
        synchronized (iConfig) {
            if (this.compiledCache != null) {
                this.compiledCache.remove(name);
            }
        }
        super.setString(name, value);
    }

    public abstract IConfig getParent();

    public boolean canSave() {
        IConfig parent = this.getParent();
        if (parent == null) {
            return false;
        }
        return parent.canSave();
    }

    public void save() throws MException {
        IConfig parent = this.getParent();
        if (parent == null) {
            log.d("can't save config", this);
            return;
        }
        parent.save();
    }

    @Override
    public Set<String> keys() {
        return new ArraySet<String>(this.getPropertyKeys());
    }

    private class ConfigMap
    implements Map<String, Object> {
        private int level;

        private ConfigMap(int level) {
            this.level = level;
        }

        @Override
        public int size() {
            return 0;
        }

        public int getLevel() {
            return this.level;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean containsKey(Object key) {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        public Object get(Object key) {
            return null;
        }

        @Override
        public Object put(String key, Object value) {
            return null;
        }

        @Override
        public Object remove(Object key) {
            return null;
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> m) {
        }

        @Override
        public void clear() {
        }

        @Override
        public Set<String> keySet() {
            return null;
        }

        @Override
        public Collection<Object> values() {
            return null;
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return null;
        }
    }

    private class ConfigAttributePart
    implements StringPart {
        private String name;
        private String def;
        private IConfig config;

        public ConfigAttributePart(String part) {
            this.name = part;
            int pos = this.name.indexOf(44);
            if (pos > 0) {
                this.def = this.name.substring(pos + 1);
                this.name = this.name.substring(0, pos);
            }
            this.config = IConfig.this;
            while (this.name.startsWith("../")) {
                this.config = this.config.getParent();
                this.name = this.name.substring(3);
                if (this.config != null) continue;
                break;
            }
        }

        @Override
        public void execute(StringBuffer out, Map<String, Object> attributes) {
            int level = 0;
            if (attributes != null && attributes instanceof ConfigMap) {
                level = ((ConfigMap)attributes).getLevel();
            }
            if (this.config == null) {
                out.append(this.def);
            } else {
                out.append(this.config.getExtracted(this.name, this.def, level));
            }
        }

        @Override
        public void dump(int level, StringBuffer out) {
            MString.appendRepeating(level, ' ', out);
            out.append(this.getClass().getCanonicalName()).append(this.name).append("(").append(this.def).append(")");
        }
    }

    private class RootAttributePart
    implements StringPart {
        private String name;
        private String def;
        private IConfig root;

        public RootAttributePart(String part) {
            this.name = MString.afterIndex(part, '.');
            this.root = IConfig.this;
            while (this.root.getParent() != null && this.root.getParent() != this.root) {
                this.root = this.root.getParent();
            }
            int pos = this.name.indexOf(44);
            if (pos > 0) {
                this.def = this.name.substring(pos + 1);
                this.name = this.name.substring(0, pos);
            }
        }

        @Override
        public void execute(StringBuffer out, Map<String, Object> attributes) {
            out.append(this.root.getString(this.name, this.def));
        }

        @Override
        public void dump(int level, StringBuffer out) {
            MString.appendRepeating(level, ' ', out);
            out.append(this.getClass().getCanonicalName()).append(this.name).append("(").append(this.def).append(")");
        }
    }

    private class ConfigStringCompiler
    extends StringCompiler {
        private ConfigStringCompiler() {
        }

        @Override
        protected StringPart createDefaultAttributePart(String part) {
            if (part.startsWith("root.")) {
                return new RootAttributePart(part);
            }
            if (part.startsWith(">>>")) {
                return new DefaultScriptPart(part);
            }
            return new ConfigAttributePart(part);
        }
    }
}

