/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.config;

import de.mhus.lib.MCast;
import de.mhus.lib.MException;
import de.mhus.lib.config.IConfig;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class HashConfig
extends IConfig {
    private HashMap<String, String> properties = null;
    private HashMap<String, LinkedList<HashConfig>> children = null;
    private String name;
    private IConfig parent;

    public HashConfig() {
        this(null, null);
    }

    public HashConfig(String name, IConfig parent) {
        this.name = name;
        this.parent = parent;
        this.properties = new HashMap();
        this.children = new HashMap();
    }

    public HashConfig(Map<String, String> fill) {
        this(null, null);
        if (fill != null) {
            this.properties.putAll(fill);
        }
    }

    @Override
    public String[] getPropertyKeys() {
        return this.properties.keySet().toArray(new String[this.properties.size()]);
    }

    @Override
    public IConfig getConfig(String key) {
        LinkedList<HashConfig> list = this.children.get(key);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.getFirst();
    }

    @Override
    public IConfig[] getConfigBundle(String key) {
        LinkedList<HashConfig> list = this.children.get(key);
        if (list == null || list.size() == 0) {
            return new IConfig[0];
        }
        return list.toArray(new HashConfig[list.size()]);
    }

    @Override
    public IConfig[] getConfigBundle() {
        LinkedList<HashConfig> out = new LinkedList<HashConfig>();
        for (Map.Entry<String, LinkedList<HashConfig>> item : this.children.entrySet()) {
            LinkedList<HashConfig> list = item.getValue();
            for (HashConfig item2 : list) {
                out.add(item2);
            }
        }
        if (out == null || out.size() == 0) {
            return new IConfig[0];
        }
        return out.toArray(new HashConfig[out.size()]);
    }

    @Override
    public String[] getConfigKeys() {
        return this.children.keySet().toArray(new String[this.children.size()]);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IConfig createConfig(String key) throws MException {
        HashConfig child = new HashConfig(key, this);
        LinkedList<HashConfig> list = this.children.get(key);
        if (list == null) {
            list = new LinkedList();
            this.children.put(key, list);
        }
        list.add(child);
        return child;
    }

    @Override
    public int moveConfig(IConfig config, int newPos) throws MException {
        if (!(config instanceof HashConfig)) {
            throw new MException(new Object[]{"not a hashconfig"});
        }
        LinkedList<HashConfig> list = this.children.get(config.getName());
        if (list == null || list.size() == 0 || !list.contains(config)) {
            throw new MException(new Object[]{"config not in my list"});
        }
        if (list.size() == 1) {
            if (newPos == -102 || newPos == -103 || newPos == 0) {
                return 0;
            }
            throw new MException(new Object[]{"out of range"});
        }
        if (newPos == -102) {
            list.remove(config);
            list.add(0, (HashConfig)config);
            return 0;
        }
        if (newPos == -103) {
            list.remove(config);
            list.add((HashConfig)config);
            return list.size() - 1;
        }
        if (newPos == -101) {
            int pos = list.indexOf(config);
            if (pos == list.size() - 1) {
                throw new MException(new Object[]{"out of range"});
            }
            list.remove(config);
            list.add(pos + 1, (HashConfig)config);
            return pos + 1;
        }
        if (newPos == -100) {
            int pos = list.indexOf(config);
            if (pos == 0) {
                throw new MException(new Object[]{"out of range"});
            }
            list.remove(config);
            list.add(pos - 1, (HashConfig)config);
            return pos - 1;
        }
        if (newPos < 0 || newPos >= list.size()) {
            throw new MException(new Object[]{"out of range"});
        }
        list.remove(config);
        list.add(newPos, (HashConfig)config);
        return newPos;
    }

    @Override
    public void removeConfig(IConfig config) throws MException {
        if (!(config instanceof HashConfig)) {
            return;
        }
        LinkedList<HashConfig> list = this.children.get(config.getName());
        if (list == null) {
            return;
        }
        list.remove(config);
        if (list.size() == 0) {
            this.children.remove(list);
        }
    }

    @Override
    public String getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public boolean isProperty(String name) {
        return this.properties.containsKey(name);
    }

    @Override
    public void removeProperty(String key) throws MException {
        this.properties.remove(key);
    }

    @Override
    public void setProperty(String key, Object value) throws MException {
        this.properties.put(key, MCast.objectToString(value));
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public IConfig getParent() {
        return this.parent;
    }

    @Override
    public Set<String> keys() {
        return this.properties.keySet();
    }
}

