/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.config;

import de.mhus.lib.config.IConfig;
import de.mhus.lib.config.IConfigProvider;
import de.mhus.lib.config.IConfigRoot;
import de.mhus.lib.config.MConfigFactory;
import de.mhus.lib.logging.Log;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;

public class DirectoryConfigProvider
extends IConfigProvider {
    private static Log log = Log.getLog(DirectoryConfigProvider.class);
    private File dir;
    private MConfigFactory factory;
    private boolean createNew;

    public DirectoryConfigProvider(File directory, boolean createNew) {
        this(MConfigFactory.getInstance(), directory, createNew);
    }

    public DirectoryConfigProvider(MConfigFactory factory, File directory, boolean createNew) {
        this.factory = factory;
        this.dir = directory;
        this.createNew = createNew;
    }

    @Override
    protected IConfig createConfig(String key) throws Exception {
        log.t("loading", this.dir, key);
        File f = new File(this.dir, key);
        if (f.exists() && f.isFile()) {
            IConfig config = this.factory.createConfigForFile(key);
            if (!(config instanceof IConfigRoot)) {
                return null;
            }
            try {
                FileReader reader = new FileReader(f);
                ((IConfigRoot)((Object)config)).readConfig(reader);
                reader.close();
            }
            catch (Exception e) {
                log.d(this.dir, key, e);
            }
        } else {
            if (!f.exists() && this.createNew) {
                IConfig config = this.factory.createConfigForFile(key);
                return config;
            }
            log.t("config not found", this.dir, key);
        }
        return null;
    }

    @Override
    public boolean isWriteable() {
        return this.dir.canWrite();
    }

    @Override
    protected void writeConfiguration(String name, IConfigRoot config) {
        log.t("writing", this.dir, name);
        File f = new File(this.dir, name);
        if (!this.createNew && !f.exists()) {
            log.d("can't write new config", this.dir, name);
            return;
        }
        try {
            FileWriter writer = new FileWriter(f);
            config.writeConfig(writer);
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            log.d(this.dir, name, e);
        }
    }
}

