/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.config;

import de.mhus.lib.MArgs;
import de.mhus.lib.MSingleton;
import de.mhus.lib.MSystem;
import de.mhus.lib.MXml;
import de.mhus.lib.config.ConfigBuilder;
import de.mhus.lib.config.IConfig;
import de.mhus.lib.config.JsonConfig;
import de.mhus.lib.config.PropertiesConfig;
import de.mhus.lib.config.XmlConfig;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import org.w3c.dom.Document;

public class ConfigUtil {
    public static void dump(IConfig config, PrintStream writer) {
        ConfigUtil.dump(config, writer, 0);
    }

    private static void dump(IConfig config, PrintStream writer, int level) {
        ConfigUtil.repeatSpace(writer, level);
        writer.print("{");
        writer.println(config.getName());
        for (String key : config.getPropertyKeys()) {
            ConfigUtil.repeatSpace(writer, level + 1);
            writer.print(key);
            writer.print("=");
            writer.println(config.getString(key, "[null]"));
        }
        for (String subName : config.getConfigKeys()) {
            ConfigUtil.repeatSpace(writer, level);
            writer.print(subName);
            writer.println(":");
            for (IConfig sub : config.getConfigBundle(subName)) {
                ConfigUtil.dump(sub, writer, level + 1);
            }
        }
        ConfigUtil.repeatSpace(writer, level);
        writer.println("}");
    }

    private static void repeatSpace(PrintStream writer, int level) {
        for (int i = 0; i < level; ++i) {
            writer.print("  ");
        }
    }

    public static void write(IConfig config, Writer writer, boolean intend) throws Exception {
        XmlConfig jcon = null;
        if (config instanceof JsonConfig) {
            jcon = (XmlConfig)config;
        } else {
            jcon = new XmlConfig();
            new ConfigBuilder().cloneConfig(config, jcon);
        }
        jcon.writeConfig(writer, intend);
    }

    public static String toString(IConfig config) throws Exception {
        return ConfigUtil.toString(config, true);
    }

    public static String toString(IConfig config, boolean intend) throws Exception {
        StringWriter writer = new StringWriter();
        ConfigUtil.write(config, writer, intend);
        return writer.toString();
    }

    public static boolean checkCondition(IConfig out) {
        if (out == null) {
            return false;
        }
        IConfig cc = out.getConfig("condition");
        if (cc != null) {
            String ifarg = cc.getExtracted("argument_exist");
            String ifnarg = cc.getExtracted("argument_not_exist");
            MArgs args = MSingleton.instance().getArguments();
            if (ifarg != null && args != null) {
                return args.contains(ifarg);
            }
            if (ifnarg != null && args != null) {
                return !args.contains(ifnarg);
            }
            String envname = cc.getExtracted("environment_name");
            String enveq = cc.getExtracted("environment_eq");
            String envExist = cc.getExtracted("environment_exist");
            String envNotExist = cc.getExtracted("environment_not_exist");
            if (envname != null && enveq != null) {
                return enveq.equals(System.getenv(envname));
            }
            if (envExist != null) {
                return System.getenv(envExist) != null;
            }
            if (envNotExist != null) {
                return System.getenv(envNotExist) == null;
            }
            String mainClass1 = cc.getExtracted("main_class");
            String mainClass2 = MSystem.getMainClassName();
            if (mainClass1 != null && mainClass2 != null) {
                return mainClass1.equals(mainClass2);
            }
            return false;
        }
        return true;
    }

    public static String toXmlDump(IConfig config) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ConfigUtil.toXmlDump(config, pw);
        pw.flush();
        return sw.toString();
    }

    public static void toXmlDump(IConfig config, PrintWriter pw) {
        pw.print("<");
        pw.print(MXml.encode(config.getName()));
        pw.print(" ");
        for (String key : config.getPropertyKeys()) {
            pw.print(MXml.encode(key));
            pw.print("=\"");
            pw.print(MXml.encode(config.getExtracted(key)));
            pw.print("\" ");
        }
        pw.print(">");
        for (IConfig c : config.getConfigBundle()) {
            ConfigUtil.toXmlDump(c, pw);
        }
        pw.print("</");
        pw.print(MXml.encode(config.getName()));
        pw.print(">");
    }

    public static IConfig loadXmlForClass(Class<?> clazz) throws Exception {
        String path = clazz.getCanonicalName().replaceAll("\\.", "/") + ".xml";
        InputStream res = clazz.getClassLoader().getResourceAsStream(path);
        Document xml = MXml.loadXml(res);
        return new XmlConfig(xml.getDocumentElement());
    }

    public static IConfig loadPropertiesForClass(Class<?> clazz) throws Exception {
        String path = clazz.getCanonicalName().replaceAll("\\.", "/") + ".properties";
        InputStream res = clazz.getClassLoader().getResourceAsStream(path);
        Properties prop = new Properties();
        prop.load(res);
        return new PropertiesConfig(prop);
    }
}

