/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.config;

import de.mhus.lib.MException;
import de.mhus.lib.config.IConfig;
import de.mhus.lib.logging.Log;

public class ConfigBuilder {
    private static Log log = Log.getLog(ConfigBuilder.class);

    public void cloneConfig(IConfig src, IConfig tar) {
        this.preProcess(src, tar);
        for (String key : src.getPropertyKeys()) {
            if (!this.accept(src, key)) continue;
            try {
                tar.setProperty(key, this.mapProperty(src, key, src.getString(key, null)));
            }
            catch (MException e) {
                log.i("property", key, e);
            }
        }
        for (String key : src.getConfigKeys()) {
            for (IConfig srcSub : src.getConfigBundle(key)) {
                if (!this.accept(srcSub)) continue;
                try {
                    IConfig tarSub = tar.createConfig(key);
                    this.cloneConfig(srcSub, tarSub);
                }
                catch (MException e) {
                    e.printStackTrace();
                }
            }
        }
        this.postProcess(src, tar);
    }

    boolean accept(IConfig src) {
        return true;
    }

    void preProcess(IConfig src, IConfig tar) {
    }

    void postProcess(IConfig src, IConfig tar) {
    }

    String mapProperty(IConfig src, String key, String value) {
        return value;
    }

    boolean accept(IConfig src, String key) {
        return true;
    }
}

