/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.config;

import de.mhus.lib.MActivator;
import de.mhus.lib.MSingleton;
import de.mhus.lib.config.IConfig;
import de.mhus.lib.config.IConfigProvider;
import de.mhus.lib.config.IConfigRoot;
import de.mhus.lib.config.MConfigFactory;
import de.mhus.lib.logging.Log;
import java.io.InputStream;
import java.io.InputStreamReader;

public class ClasspathConfigProvider
extends IConfigProvider {
    private static Log log = Log.getLog(ClasspathConfigProvider.class);
    private MConfigFactory factory;
    private MActivator activator;
    private String prefix;

    public ClasspathConfigProvider(Class<?> clazz) {
        this(MConfigFactory.getInstance(), MSingleton.instance().getActivator(), clazz.getPackage().getName());
    }

    public ClasspathConfigProvider(String prefix) {
        this(MConfigFactory.getInstance(), MSingleton.instance().getActivator(), prefix);
    }

    public ClasspathConfigProvider(MConfigFactory factory, MActivator activator, String prefix) {
        this.factory = factory;
        this.activator = activator;
        this.prefix = prefix;
    }

    @Override
    protected IConfig createConfig(String key) {
        log.t("loading", this.prefix, key);
        String path = this.prefix + "." + key;
        try {
            InputStream res = this.activator.getResource(path);
            if (res == null) {
                return null;
            }
            IConfig config = this.factory.createConfigForFile(key);
            if (!(config instanceof IConfigRoot)) {
                return null;
            }
            InputStreamReader reader = new InputStreamReader(res);
            ((IConfigRoot)((Object)config)).readConfig(reader);
            reader.close();
            return config;
        }
        catch (Exception e) {
            log.d(this.prefix, key, e);
            return null;
        }
    }

    @Override
    public boolean isWriteable() {
        return false;
    }

    @Override
    protected void writeConfiguration(String name, IConfigRoot config) {
    }
}

