/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.cao.util;

import de.mhus.lib.MCast;
import de.mhus.lib.MDate;
import de.mhus.lib.cao.CaoAccess;
import de.mhus.lib.cao.CaoElement;
import de.mhus.lib.cao.CaoException;
import de.mhus.lib.cao.CaoList;
import de.mhus.lib.cao.CaoMetaDefinition;
import de.mhus.lib.cao.CaoMetadata;
import de.mhus.lib.cao.CaoWritableElement;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public abstract class WritableElement
extends CaoWritableElement {
    protected Map<String, Object> data = new HashMap<String, Object>();

    public WritableElement(CaoElement master) throws CaoException {
        super(master);
    }

    @Override
    public void setBoolean(String name, boolean value) throws CaoException {
        CaoMetaDefinition def = this.master.getMetadata().getDefinition(name);
        if (def == null || def.getType() != CaoMetaDefinition.TYPE.BOOLEAN) {
            throw new CaoException(new Object[]{"Unknown attribute: " + name});
        }
        this.setString(name, String.valueOf(value));
    }

    @Override
    public void setCalendar(String name, Calendar value) throws CaoException {
        CaoMetaDefinition def = this.master.getMetadata().getDefinition(name);
        if (def == null || def.getType() != CaoMetaDefinition.TYPE.DATETIME) {
            throw new CaoException(new Object[]{"Unknown attribute: " + name});
        }
        this.setString(name, MCast.toString(value));
    }

    @Override
    public void setDate(String name, MDate value) throws CaoException {
        CaoMetaDefinition def = this.master.getMetadata().getDefinition(name);
        if (def == null || def.getType() != CaoMetaDefinition.TYPE.DATETIME) {
            throw new CaoException(new Object[]{"Unknown attribute: " + name});
        }
        this.setString(name, value.toString());
    }

    @Override
    public void setDouble(String name, double value) throws CaoException {
        CaoMetaDefinition def = this.master.getMetadata().getDefinition(name);
        if (def == null || def.getType() != CaoMetaDefinition.TYPE.DOUBLE) {
            throw new CaoException(new Object[]{"Unknown attribute: " + name});
        }
        this.setString(name, MCast.toString(value));
    }

    @Override
    public void setList(String name, CaoList value) throws CaoException {
        CaoMetaDefinition def = this.master.getMetadata().getDefinition(name);
        if (def == null || def.getType() != CaoMetaDefinition.TYPE.LIST) {
            throw new CaoException(new Object[]{"Unknown attribute: " + name});
        }
        this.data.put(name, value);
    }

    @Override
    public void setLong(String name, long value) throws CaoException {
        CaoMetaDefinition def = this.master.getMetadata().getDefinition(name);
        if (def == null || def.getType() != CaoMetaDefinition.TYPE.LONG) {
            throw new CaoException(new Object[]{"Unknown attribute: " + name});
        }
        this.setString(name, String.valueOf(value));
    }

    @Override
    public void setObject(String name, Object value) throws CaoException {
        CaoMetaDefinition def = this.master.getMetadata().getDefinition(name);
        if (def == null || def.getType() != CaoMetaDefinition.TYPE.OBJECT) {
            throw new CaoException(new Object[]{"Unknown attribute: " + name});
        }
        this.data.put(name, value);
    }

    @Override
    public void setString(String name, String value) throws CaoException {
        CaoMetaDefinition def = this.master.getMetadata().getDefinition(name);
        if (def == null) {
            throw new CaoException(new Object[]{"Unknown attribute: " + name});
        }
        this.data.put(name, value);
    }

    @Override
    public boolean getBoolean(String name, boolean def) {
        Object v = this.data.get(name);
        if (v == null) {
            return this.master.getBoolean(name, def);
        }
        return MCast.toboolean(v.toString(), false);
    }

    @Override
    public CaoList getChildren(CaoAccess CaoAccess2) throws CaoException {
        return null;
    }

    @Override
    public Calendar getCalendar(String name) {
        Object v = this.data.get(name);
        if (v == null) {
            return this.master.getCalendar(name);
        }
        return MCast.toCalendar(v.toString());
    }

    @Override
    public double getDouble(String name, double def) {
        Object v = this.data.get(name);
        if (v == null) {
            return this.master.getDouble(name, def);
        }
        return MCast.todouble(v.toString(), 0.0);
    }

    @Override
    public String getId() throws CaoException {
        return this.master.getId();
    }

    @Override
    public CaoList getList(String name, CaoAccess CaoAccess2, String ... attributes) throws CaoException {
        Object v = this.data.get(name);
        if (v == null) {
            return this.master.getList(name, CaoAccess2, attributes);
        }
        return (CaoList)v;
    }

    @Override
    public long getLong(String name, long def) {
        Object v = this.data.get(name);
        if (v == null) {
            return this.master.getLong(name, def);
        }
        return Long.valueOf(v.toString());
    }

    @Override
    public CaoMetadata getMetadata() {
        return this.master.getMetadata();
    }

    @Override
    public String getName() throws CaoException {
        return this.master.getName();
    }

    @Override
    public Object getObject(String name, String ... attributes) throws CaoException {
        Object v = this.data.get(name);
        if (v == null) {
            return this.master.getObject(name, new String[0]);
        }
        return v;
    }

    @Override
    public String getString(String name) throws CaoException {
        Object v = this.data.get(name);
        if (v == null) {
            return this.master.getString(name);
        }
        return v.toString();
    }

    @Override
    public CaoWritableElement getWritableNode() {
        return this;
    }

    @Override
    public boolean isNode() {
        return this.master.isNode();
    }

    @Override
    public boolean isWritable() {
        return this.master.isWritable();
    }

    @Override
    public void reload() throws CaoException {
        this.data.clear();
    }

    @Override
    public abstract void save() throws CaoException;

    @Override
    public boolean isLocked(boolean owner) throws CaoException {
        return this.master.isLocked(owner);
    }

    @Override
    public boolean lock(int timeout) throws CaoException {
        return this.master.lock(timeout);
    }

    @Override
    public boolean unlock() throws CaoException {
        return this.master.unlock();
    }

    @Override
    public boolean isDirty() {
        return this.data.size() != 0;
    }
}

