/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.cao.util;

import de.mhus.lib.cao.CaoElement;
import de.mhus.lib.cao.CaoException;
import de.mhus.lib.cao.CaoList;
import de.mhus.lib.cao.CaoListIterator;
import de.mhus.lib.cao.CaoMetaDefinition;
import de.mhus.lib.cao.CaoMetadata;
import de.mhus.lib.cao.util.CombinedMetadata;
import de.mhus.lib.cao.util.StringElement;

public class StringArrayList
extends CaoList {
    private String[] values;
    private CombinedMetadata meta;

    public StringArrayList(CaoElement parent, String id, String[] values, CaoMetaDefinition metad) {
        super(parent, id);
        this.values = values;
        this.meta = new CombinedMetadata(this.getDriver());
        this.meta.addMetaDefinition(metad.getName(), metad.getType(), metad.getNls(), metad.getSize(), metad.getCategories());
    }

    public StringArrayList(CaoElement parent, String id, String[] values, String mName, CaoMetaDefinition.TYPE mType, String mNls, long mSize, String ... mCategories) {
        super(parent, id);
        this.values = values;
        this.meta = new CombinedMetadata(this.getDriver());
        this.meta.addMetaDefinition(mName, mType, mNls, mSize, mCategories);
    }

    @Override
    public CaoMetadata getMetadata() {
        return this.meta;
    }

    @Override
    public int size() {
        return this.values.length;
    }

    public String[] getArray() {
        return this.values;
    }

    @Override
    public CaoListIterator getElements() {
        return new ListIterator();
    }

    private class ListIterator
    extends CaoListIterator {
        private int index;

        protected ListIterator() {
            super(StringArrayList.this.getConnection());
            this.reset();
        }

        @Override
        protected boolean hasNextElement() {
            return StringArrayList.this.values.length > this.index;
        }

        @Override
        protected CaoElement nextElement() throws CaoException {
            if (StringArrayList.this.values.length <= this.index) {
                return null;
            }
            return new StringElement(StringArrayList.this.getParent(), StringArrayList.this.meta, StringArrayList.this.values[this.index++]);
        }

        @Override
        public void reset() {
            this.index = 0;
        }
    }
}

