/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.cao.util;

import de.mhus.lib.MException;
import de.mhus.lib.MThread;
import de.mhus.lib.cao.CaoAccess;
import de.mhus.lib.cao.CaoApplication;
import de.mhus.lib.cao.CaoElement;
import de.mhus.lib.cao.CaoException;
import de.mhus.lib.cao.CaoInvalidException;
import de.mhus.lib.cao.CaoList;
import de.mhus.lib.cao.CaoMetaDefinition;
import de.mhus.lib.cao.CaoMetadata;
import de.mhus.lib.cao.CaoNotFoundException;
import de.mhus.lib.cao.CaoWritableElement;
import de.mhus.lib.cao.util.LinkedCaoList;
import de.mhus.lib.cao.util.MutableMetadata;
import de.mhus.lib.cao.util.WritableElement;
import de.mhus.lib.util.NullableMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MutableElement
extends CaoElement {
    private boolean isNode = false;
    private String id = "?";
    private String name = "?";
    private MutableMetadata meta;
    protected NullableMap<String, Object> data = new NullableMap();
    private boolean writable = true;
    private boolean locked = false;
    private boolean valid = true;
    private CaoList children;

    public MutableElement(CaoApplication app) throws CaoException {
        super(app);
        this.meta = new MutableMetadata(this.getDriver());
    }

    public MutableElement(CaoElement parent) throws CaoException {
        super(parent);
        this.meta = new MutableMetadata(this.getDriver());
    }

    @Override
    public CaoList getChildren(CaoAccess access) throws CaoException {
        return this.children;
    }

    public void setChildren(CaoList in) {
        this.children = in;
    }

    @Override
    public boolean isNode() {
        return this.isNode;
    }

    @Override
    public String getId() throws CaoException {
        return this.id;
    }

    @Override
    public String getName() throws CaoException {
        return this.name;
    }

    @Override
    public CaoMetadata getMetadata() {
        return this.meta;
    }

    public void setMetadata(MutableMetadata meta) {
        this.meta = meta;
    }

    public List<CaoMetaDefinition> getMetaDefinitions() {
        return this.meta.getMap();
    }

    @Override
    public String getString(String name) throws CaoException {
        if (!this.data.containsKey(name)) {
            throw new CaoNotFoundException(this.getName(), name);
        }
        Object out = this.data.get(name);
        if (out == null) {
            return null;
        }
        return out.toString();
    }

    @Override
    public CaoList getList(String name, CaoAccess access, String ... attributes) throws CaoException {
        Object out = this.data.get(name);
        if (out == null || !(out instanceof List)) {
            throw new CaoNotFoundException(this.getName(), name);
        }
        return new LinkedCaoList((CaoElement)this, (List)out);
    }

    @Override
    public Object getObject(String name, String ... attributes) throws CaoException {
        if (!this.data.containsKey(name)) {
            throw new CaoNotFoundException(this.getName(), name);
        }
        Object out = this.data.get(name);
        return out;
    }

    @Override
    public boolean isWritable() {
        return this.writable;
    }

    @Override
    public CaoWritableElement getWritableNode() throws CaoException {
        if (!this.isWritable()) {
            throw new CaoInvalidException("Element is not writable");
        }
        return new WritableElement(this){

            @Override
            public boolean isValid() {
                return this.getParent().isValid();
            }

            @Override
            public boolean isWritable(String name) {
                return this.getParent().isWritable();
            }

            @Override
            public void save() throws CaoException {
                for (Map.Entry entry : this.data.entrySet()) {
                    MutableElement.this.setObject((String)entry.getKey(), entry.getValue());
                }
                MutableElement.this.save();
            }

            @Override
            public Set<String> keys() {
                return this.data.keySet();
            }
        };
    }

    protected void save() throws CaoException {
    }

    public void setObject(String key, Object value) throws CaoException {
        this.data.put(key, value);
    }

    @Override
    public void reload() throws CaoException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lock(int timeout) throws CaoException {
        if (timeout < 0) {
            throw new CaoInvalidException("timeout less zero");
        }
        MutableElement mutableElement = this;
        synchronized (mutableElement) {
            while (this.locked) {
                MThread.sleep(100L);
                if (timeout == 0 || (timeout -= 100) > 0) continue;
                return false;
            }
            this.locked = true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unlock() throws CaoException {
        boolean out = true;
        MutableElement mutableElement = this;
        synchronized (mutableElement) {
            out = this.locked;
            this.locked = false;
        }
        return out;
    }

    @Override
    public boolean isLocked(boolean owner) throws CaoException {
        return this.locked;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    public void setNode(boolean isNode) {
        this.isNode = isNode;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setWritable(boolean writable) {
        this.writable = writable;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    @Override
    public void setProperty(String key, Object value) throws MException {
        this.setObject(key, value);
    }

    @Override
    public void removeProperty(String key) throws MException {
        this.data.remove(key);
    }

    @Override
    public Set<String> keys() {
        return this.data.keySet();
    }
}

