/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.cao.util;

import de.mhus.lib.cao.CaoElement;
import de.mhus.lib.cao.CaoException;
import de.mhus.lib.cao.CaoList;
import de.mhus.lib.cao.CaoListIterator;
import de.mhus.lib.cao.CaoMetadata;
import de.mhus.lib.cao.util.CombinedMetadata;
import java.util.Iterator;
import java.util.LinkedList;

public class MutableCaoList
extends CaoList {
    private LinkedList<CaoElement> data;
    private CombinedMetadata meta;

    public MutableCaoList(CaoElement parent, LinkedList<CaoElement> data) throws CaoException {
        super(parent, null);
        this.data = data;
        this.refreshMetadata();
    }

    public LinkedList<CaoElement> getList() {
        return this.data;
    }

    public void refreshMetadata() {
        this.meta = new CombinedMetadata(this.getDriver());
        for (CaoElement ele : this.data) {
            this.meta.addMetaDefinitions(ele.getMetadata());
        }
    }

    @Override
    public CaoMetadata getMetadata() {
        return this.meta;
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public CaoListIterator getElements() {
        return new ListIterator();
    }

    @Override
    public CaoElement getParent() {
        return null;
    }

    private class ListIterator
    extends CaoListIterator {
        private Iterator<CaoElement> iterator;

        protected ListIterator() {
            super(MutableCaoList.this.getConnection());
            this.reset();
        }

        @Override
        public boolean hasNextElement() {
            return this.iterator.hasNext();
        }

        @Override
        public CaoElement nextElement() {
            return this.iterator.next();
        }

        @Override
        public void reset() {
            this.iterator = MutableCaoList.this.data.iterator();
        }
    }
}

