/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.cao.util;

import de.mhus.lib.cao.CaoElement;
import de.mhus.lib.cao.CaoException;
import de.mhus.lib.cao.CaoList;
import de.mhus.lib.cao.CaoListIterator;
import de.mhus.lib.cao.CaoMetadata;
import de.mhus.lib.cao.util.CombinedMetadata;
import java.util.Iterator;
import java.util.List;

public class LinkedCaoList
extends CaoList {
    private List<CaoElement> data;
    private CombinedMetadata meta;

    public LinkedCaoList(CaoElement parent, List<CaoElement> data) throws CaoException {
        super(parent, null);
        this.data = data;
        this.meta = new CombinedMetadata(this.getDriver());
        for (CaoElement ele : data) {
            this.meta.addMetaDefinitions(ele.getMetadata());
        }
    }

    @Override
    public CaoMetadata getMetadata() {
        return this.meta;
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public CaoListIterator getElements() {
        return new ListIterator();
    }

    @Override
    public CaoElement getParent() {
        return null;
    }

    private class ListIterator
    extends CaoListIterator {
        private Iterator<CaoElement> iterator;

        protected ListIterator() {
            super(LinkedCaoList.this.getConnection());
            this.reset();
        }

        @Override
        public boolean hasNextElement() {
            return this.iterator.hasNext();
        }

        @Override
        public CaoElement nextElement() {
            return this.iterator.next();
        }

        @Override
        public void reset() {
            this.iterator = LinkedCaoList.this.data.iterator();
        }
    }
}

