/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.cao.util;

import de.mhus.lib.MException;
import de.mhus.lib.MString;
import de.mhus.lib.cao.CaoMetaDefinition;
import de.mhus.lib.cao.CaoMetadata;
import de.mhus.lib.cao.util.MetadataBundle;
import de.mhus.lib.config.IConfig;
import java.util.Map;

public class CaoExport {
    public static void fillTables(MetadataBundle bundle, IConfig config) throws MException {
        for (Map.Entry<String, CaoMetadata> meta : bundle.getBundle().entrySet()) {
            IConfig cTab = config.createConfig("table");
            cTab.setProperty("name", meta.getKey());
            CaoExport.fillColumns(meta.getValue(), cTab);
        }
    }

    public static void fillColumns(CaoMetadata meta, IConfig config) throws MException {
        for (CaoMetaDefinition m : meta) {
            IConfig cM = config.createConfig("column");
            cM.setProperty("name", m.getName());
            cM.setProperty("type", m.getType().toString());
            if (m.getNls() != null) {
                cM.setProperty("nls", m.getNls());
            }
            if (m.getSize() > 0L) {
                cM.setProperty("size", String.valueOf(m.getSize()));
            }
            if (m.getCategories() == null) continue;
            cM.setProperty("categories", MString.join(m.getCategories(), ','));
        }
    }
}

