/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.cao;

import de.mhus.lib.cao.CaoApplication;
import de.mhus.lib.cao.CaoElement;
import de.mhus.lib.cao.CaoException;
import de.mhus.lib.cao.CaoMetaDefinition;
import de.mhus.lib.cao.CaoPolicy;
import java.util.LinkedList;

public class CaoPrincipal
extends CaoPolicy {
    public static final String NAME = "name";
    public static final String PRINCIPAL_TYPE = "principal_type";
    private String name;
    protected int principalType;

    public CaoPrincipal(CaoElement element, String name, PRINCIPAL_TYPES type, boolean readable, boolean writable) throws CaoException {
        super(element, readable, writable);
        this.name = name;
        this.principalType = type.ordinal();
    }

    public CaoPrincipal(CaoApplication app, String name, PRINCIPAL_TYPES type, boolean readable, boolean writable) throws CaoException {
        super(app, readable, writable);
        this.name = name;
        this.principalType = type.ordinal();
    }

    @Override
    protected void fillMetaData(LinkedList<CaoMetaDefinition> definition) {
        definition.add(new CaoMetaDefinition(this.meta, NAME, CaoMetaDefinition.TYPE.STRING, null, 256L, new String[0]));
        definition.add(new CaoMetaDefinition(this.meta, PRINCIPAL_TYPE, CaoMetaDefinition.TYPE.LONG, null, 0L, new String[0]));
    }

    @Override
    public String getName() throws CaoException {
        return this.name;
    }

    public PRINCIPAL_TYPES getPrincipalType() {
        try {
            long index = this.getLong(PRINCIPAL_TYPE, PRINCIPAL_TYPES.OTHER.ordinal());
            if (index < 0L || index > (long)PRINCIPAL_TYPES.values().length) {
                return PRINCIPAL_TYPES.OTHER;
            }
            return PRINCIPAL_TYPES.values()[(int)index];
        }
        catch (Exception e) {
            return PRINCIPAL_TYPES.OTHER;
        }
    }

    @Override
    public String getString(String name) throws CaoException {
        if (NAME.equals(name)) {
            return this.name;
        }
        if (PRINCIPAL_TYPE.equals(name)) {
            return String.valueOf(this.principalType);
        }
        return super.getString(name);
    }

    public static enum PRINCIPAL_TYPES {
        USER,
        GROUP,
        ROLE,
        OTHER;

    }
}

