/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.cao;

import de.mhus.lib.MCast;
import de.mhus.lib.cao.CaoAccess;
import de.mhus.lib.cao.CaoApplication;
import de.mhus.lib.cao.CaoElement;
import de.mhus.lib.cao.CaoException;
import de.mhus.lib.cao.CaoList;
import de.mhus.lib.cao.CaoMetaDefinition;
import de.mhus.lib.cao.CaoMetadata;
import de.mhus.lib.cao.CaoNotFoundException;
import de.mhus.lib.cao.CaoNotSupportedException;
import de.mhus.lib.cao.CaoWritableElement;
import de.mhus.lib.cao.util.MutableCaoList;
import java.util.LinkedList;
import java.util.Set;

public class CaoPolicy
extends CaoElement {
    public static final String READ = "read";
    public static final String WRITE = "write";
    public static final String POLICIES = "policies";
    public static final String PRINCIPAL = "principal";
    public static final String CATEGORY_POLICY = "policy";
    public static final String CATEGORY_RIGHT = "right";
    protected boolean writable;
    protected boolean readable;
    protected CaoElement element;
    protected CaoPolicy proxy = null;
    protected CaoMetadata meta;

    public CaoPolicy(CaoElement element, boolean readable, boolean writable) throws CaoException {
        super(element);
        this.element = element;
        this.readable = readable;
        this.writable = writable;
        this.meta = new CaoMetadata(this.getConnection().getDriver());
        this.fillMetaData(this.meta.definition);
    }

    public CaoPolicy(CaoApplication app, boolean readable, boolean writable) throws CaoException {
        super(app);
        this.element = null;
        this.readable = readable;
        this.writable = writable;
        this.meta = new CaoMetadata(app.getConnection().getDriver());
        this.fillMetaData(this.meta.definition);
    }

    protected void fillMetaData(LinkedList<CaoMetaDefinition> definition) {
        definition.add(new CaoMetaDefinition(this.meta, READ, CaoMetaDefinition.TYPE.BOOLEAN, null, 0L, CATEGORY_RIGHT));
        definition.add(new CaoMetaDefinition(this.meta, WRITE, CaoMetaDefinition.TYPE.BOOLEAN, null, 0L, CATEGORY_RIGHT));
        definition.add(new CaoMetaDefinition(this.meta, POLICIES, CaoMetaDefinition.TYPE.LIST, null, 0L, CATEGORY_POLICY));
        definition.add(new CaoMetaDefinition(this.meta, PRINCIPAL, CaoMetaDefinition.TYPE.ELEMENT, null, 0L, new String[0]));
    }

    @Override
    public boolean isWritable() {
        if (this.proxy != null) {
            return this.proxy.isWritable();
        }
        return this.getBoolean(WRITE, this.writable);
    }

    public boolean isReadable() {
        if (this.proxy != null) {
            return this.proxy.isReadable();
        }
        return this.getBoolean(READ, this.readable);
    }

    @Override
    public CaoList getChildren(CaoAccess access) throws CaoException {
        if (this.proxy != null) {
            return this.proxy.getChildren();
        }
        throw new CaoNotSupportedException(new Object[0]);
    }

    @Override
    public boolean isNode() {
        if (this.proxy != null) {
            return this.proxy.isNode();
        }
        return false;
    }

    @Override
    public String getId() throws CaoException {
        if (this.proxy != null) {
            return this.proxy.getId();
        }
        return null;
    }

    @Override
    public String getName() throws CaoException {
        if (this.proxy != null) {
            return this.proxy.getName();
        }
        return null;
    }

    @Override
    public CaoMetadata getMetadata() {
        if (this.proxy != null) {
            return this.proxy.getMetadata();
        }
        return this.meta;
    }

    @Override
    public CaoElement getParent() {
        if (this.proxy != null) {
            return this.proxy.getParent();
        }
        return null;
    }

    @Override
    public String getString(String name) throws CaoException {
        if (this.proxy != null) {
            return this.proxy.getString(name);
        }
        if (name.equals(PRINCIPAL)) {
            return this.getConnection().getCurrentUser().getName();
        }
        return MCast.toString(this.getBoolean(name, false));
    }

    @Override
    public boolean getBoolean(String name, boolean def) {
        if (this.proxy != null) {
            return this.proxy.getBoolean(name, def);
        }
        if (READ.equals(name)) {
            return this.readable;
        }
        if (WRITE.equals(name)) {
            return this.writable;
        }
        return def;
    }

    @Override
    public CaoList getList(String name, CaoAccess access, String ... attributes) throws CaoException {
        if (this.proxy != null) {
            return this.proxy.getList(name, access, attributes);
        }
        if (POLICIES.equals(name)) {
            return this.getPoliciesList(attributes);
        }
        throw new CaoNotFoundException(this, "list", name);
    }

    protected CaoList getPoliciesList(String[] attributes) throws CaoException {
        LinkedList<CaoElement> list = new LinkedList<CaoElement>();
        list.add(this);
        return new MutableCaoList((CaoElement)this, list);
    }

    @Override
    public Object getObject(String name, String ... attributes) throws CaoException {
        if (this.proxy != null) {
            return this.proxy.getObject(name, attributes);
        }
        if (name.equals(PRINCIPAL)) {
            return this.getConnection().getCurrentUser();
        }
        throw new CaoNotSupportedException(new Object[0]);
    }

    @Override
    public CaoWritableElement getWritableNode() throws CaoException {
        if (this.proxy != null) {
            return this.proxy.getWritableNode();
        }
        throw new CaoNotSupportedException(new Object[0]);
    }

    @Override
    public void reload() throws CaoException {
        this.proxy = this.element.getAccessPolicy();
    }

    @Override
    public boolean lock(int timeout) throws CaoException {
        return this.element.lock(timeout);
    }

    @Override
    public boolean unlock() throws CaoException {
        return this.element.unlock();
    }

    @Override
    public boolean isLocked(boolean owner) throws CaoException {
        return this.element.isLocked(owner);
    }

    @Override
    public boolean isValid() {
        return this.element.isValid();
    }

    @Override
    public Set<String> keys() {
        return this.element.keys();
    }
}

