/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.cao;

import de.mhus.lib.MEventHandler;
import de.mhus.lib.cao.CaoConnection;
import de.mhus.lib.cao.CaoElement;
import de.mhus.lib.cao.ICaoChangeListener;
import de.mhus.lib.logging.Log;

public class CaoObserver
implements ICaoChangeListener {
    private CaoConnection connection;
    private static Log log = Log.getLog(CaoObserver.class);
    private ChangedHandler handler = new ChangedHandler();
    private ICaoChangeListener listener = null;

    public CaoObserver(CaoConnection connection) {
        this.connection = connection;
    }

    public CaoConnection getConnection() {
        return this.connection;
    }

    public void setListener(ICaoChangeListener listener) {
        this.listener = listener;
    }

    @Override
    public void elementCreated(CaoConnection con, String id) {
        this.handler.fireElementCreated(con, id);
    }

    @Override
    public void elementDeleted(CaoConnection con, String id) {
        this.handler.fireElementDeleted(con, id);
    }

    @Override
    public void elementUpdated(CaoConnection con, String id) {
        this.handler.fireElementUpdated(con, id);
    }

    @Override
    public void elementLink(CaoConnection con, String parentId, String id) {
        this.handler.fireElementLink(con, parentId, id);
    }

    @Override
    public void elementUnlink(CaoConnection con, String parentId, String id) {
        this.handler.fireElementUnlink(con, parentId, id);
    }

    @Override
    public void elementStructurChanged(CaoConnection con, String id) {
        this.handler.fireElementStructurChanged(con, id);
    }

    public void add(CaoElement elementToListen) {
        if (elementToListen == null) {
            return;
        }
        this.handler.register(elementToListen);
    }

    public void remove(CaoElement elementToListen) {
        if (elementToListen == null) {
            return;
        }
        this.handler.unregister(elementToListen);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void disconnected(CaoConnection con) {
        this.handler.fireDisconnected(con);
    }

    private class ChangedHandler
    extends MEventHandler<CaoElement> {
        ChangedHandler() {
            super(true);
        }

        public void fireElementStructurChanged(CaoConnection con, String id) {
            for (CaoElement item : this.getListeners()) {
                try {
                    if (id != null && !id.equals(item.getId()) || CaoObserver.this.listener == null || !CaoObserver.this.listener.isValid()) continue;
                    CaoObserver.this.listener.elementStructurChanged(con, id);
                }
                catch (Throwable t) {
                    log.debug(t);
                }
            }
        }

        public void fireElementLink(CaoConnection con, String parentId, String id) {
            for (CaoElement item : this.getListeners()) {
                try {
                    if (!parentId.equals(item.getId()) || CaoObserver.this.listener == null || !CaoObserver.this.listener.isValid()) continue;
                    CaoObserver.this.listener.elementLink(con, parentId, id);
                }
                catch (Throwable t) {
                    log.debug(t);
                }
            }
        }

        public void fireElementUnlink(CaoConnection con, String parentId, String id) {
            for (CaoElement item : this.getListeners()) {
                try {
                    if (!parentId.equals(item.getId()) || CaoObserver.this.listener == null || !CaoObserver.this.listener.isValid()) continue;
                    CaoObserver.this.listener.elementUnlink(con, parentId, id);
                }
                catch (Throwable t) {
                    log.debug(t);
                }
            }
        }

        public void fireElementUpdated(CaoConnection con, String id) {
            for (CaoElement item : this.getListeners()) {
                try {
                    if (!id.equals(item.getId()) || CaoObserver.this.listener == null || !CaoObserver.this.listener.isValid()) continue;
                    CaoObserver.this.listener.elementUpdated(con, id);
                }
                catch (Throwable t) {
                    log.debug(t);
                }
            }
        }

        public void fireElementCreated(CaoConnection con, String id) {
            for (CaoElement item : this.getListeners()) {
                try {
                    if (!id.equals(item.getId()) || CaoObserver.this.listener == null || !CaoObserver.this.listener.isValid()) continue;
                    CaoObserver.this.listener.elementCreated(con, id);
                }
                catch (Throwable t) {
                    log.debug(t);
                }
            }
        }

        public void fireElementDeleted(CaoConnection con, String id) {
            for (CaoElement item : this.getListeners()) {
                try {
                    if (!id.equals(item.getId()) || CaoObserver.this.listener == null || !CaoObserver.this.listener.isValid()) continue;
                    CaoObserver.this.listener.elementDeleted(con, id);
                }
                catch (Throwable t) {
                    log.debug(t);
                }
            }
        }

        public void fireDisconnected(CaoConnection con) {
            if (CaoObserver.this.listener != null && CaoObserver.this.listener.isValid()) {
                CaoObserver.this.listener.disconnected(con);
            }
        }
    }
}

