/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.cao;

import de.mhus.lib.cao.CaoDriver;
import de.mhus.lib.cao.CaoMetaDefinition;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CaoMetadata
implements Iterable<CaoMetaDefinition> {
    protected LinkedList<CaoMetaDefinition> definition = new LinkedList();
    protected HashMap<String, CaoMetaDefinition> index = null;
    private CaoDriver driver;

    public CaoMetadata(CaoDriver driver) {
        this.driver = driver;
    }

    @Override
    public Iterator<CaoMetaDefinition> iterator() {
        return this.definition.iterator();
    }

    public int getCount() {
        return this.definition.size();
    }

    public CaoMetaDefinition getDefinitionAt(int index) {
        return this.definition.get(index);
    }

    public final CaoDriver getDriver() {
        return this.driver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CaoMetaDefinition getDefinition(String name) {
        CaoMetadata caoMetadata = this;
        synchronized (caoMetadata) {
            if (this.index == null) {
                this.index = new HashMap();
                for (CaoMetaDefinition d : this) {
                    this.index.put(d.getName(), d);
                }
            }
        }
        return this.index.get(name);
    }

    public List<CaoMetaDefinition> getDefinitionsWithCategory(String category) {
        LinkedList<CaoMetaDefinition> out = new LinkedList<CaoMetaDefinition>();
        for (CaoMetaDefinition meta : this) {
            if (!meta.hasCategory(category)) continue;
            out.add(meta);
        }
        return out;
    }
}

