/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.cao;

import de.mhus.lib.cao.CaoDriver;
import de.mhus.lib.cao.CaoMetadata;

public class CaoMetaDefinition {
    private TYPE type;
    private String name;
    private String nls;
    private long size;
    private String[] categories;
    private CaoDriver driver;

    public CaoMetaDefinition(CaoMetadata meta, String name, TYPE type, String nls, long size, String ... categories) {
        this.name = name;
        this.type = type;
        this.nls = nls;
        this.size = size;
        this.categories = categories;
        this.driver = meta.getDriver();
    }

    public TYPE getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getNls() {
        return this.nls;
    }

    public long getSize() {
        return this.size;
    }

    public String[] getCategories() {
        return this.categories;
    }

    public final CaoDriver getDriver() {
        return this.driver;
    }

    public boolean hasCategory(String category) {
        if (category == null || this.categories == null) {
            return false;
        }
        for (String c : this.categories) {
            if (c == null || !c.equals(category)) continue;
            return true;
        }
        return false;
    }

    public static enum TYPE {
        STRING,
        BOOLEAN,
        LONG,
        DOUBLE,
        DATETIME,
        LIST,
        OBJECT,
        TEXT,
        BINARY,
        ELEMENT;

    }
}

