/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.cao;

import de.mhus.lib.cao.CaoConnection;
import de.mhus.lib.cao.CaoElement;
import de.mhus.lib.cao.CaoException;
import java.util.Iterator;

public abstract class CaoListIterator
implements Iterable<CaoElement>,
Iterator<CaoElement> {
    private CaoConnection connection;
    private int backCounter = -1;

    protected CaoListIterator(CaoConnection connection) {
        this.connection = connection;
    }

    public final CaoConnection getConnection() {
        return this.connection;
    }

    public void setNextIteratorCount(int count) {
        this.backCounter = count;
    }

    public void resetNextIteratorCount() {
        this.backCounter = -1;
    }

    protected abstract CaoElement nextElement() throws CaoException;

    protected abstract boolean hasNextElement() throws CaoException;

    @Override
    public CaoElement next() {
        if (this.backCounter == 0) {
            return null;
        }
        if (this.backCounter > 0) {
            --this.backCounter;
        }
        try {
            return this.nextElement();
        }
        catch (CaoException e) {
            return null;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.backCounter == 0) {
            return false;
        }
        try {
            return this.hasNextElement();
        }
        catch (CaoException e) {
            return false;
        }
    }

    public void flush(int nr) throws CaoException {
        for (int i = 0; i < nr; ++i) {
            if (!this.hasNextElement()) continue;
            this.nextElement();
        }
    }

    @Override
    public Iterator<CaoElement> iterator() {
        return this;
    }

    @Override
    public final void remove() {
    }

    public abstract void reset() throws CaoException;
}

