/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.cao;

import de.mhus.lib.MActivator;
import de.mhus.lib.cao.CaoActionForwarder;
import de.mhus.lib.cao.CaoActionList;
import de.mhus.lib.cao.CaoConnection;
import de.mhus.lib.cao.CaoDriver;
import de.mhus.lib.cao.CaoElement;
import de.mhus.lib.cao.CaoException;
import de.mhus.lib.cao.CaoForm;
import de.mhus.lib.cao.CaoList;
import de.mhus.lib.cao.IActionProvider;
import de.mhus.lib.config.IConfig;
import de.mhus.lib.logging.Log;
import java.util.HashMap;

public class CaoFactory {
    private static Log log = Log.getLog(CaoFactory.class);
    private HashMap<String, Object[]> registry = new HashMap();
    private HashMap<String, CaoDriver> drivers = new HashMap();
    private static CaoActionForwarder actionProviders = new CaoActionForwarder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CaoDriver getDriver(String service) throws CaoException {
        HashMap<String, CaoDriver> hashMap = this.drivers;
        synchronized (hashMap) {
            CaoDriver driver = this.drivers.get(service);
            if (driver == null) {
                Object[] definition = this.registry.get(service);
                try {
                    log.t("load driver", definition);
                    driver = (CaoDriver)((MActivator)definition[2]).createObject("cao.service");
                    driver.initialize(service, null, (MActivator)definition[2]);
                }
                catch (Exception e) {
                    throw new CaoException(new Object[]{"Init of driver failed: " + service, e});
                }
                this.drivers.put(service, driver);
            }
            return driver;
        }
    }

    public CaoConnection createConnection(String service, CaoForm form) throws CaoException {
        return this.getDriver(service).createConnection(form);
    }

    public CaoConnection createConnection(String service, String url, IConfig config) throws CaoException {
        return this.getDriver(service).createConnection(url, config);
    }

    public CaoForm createConfiguration(String service) throws CaoException {
        return this.getDriver(service).createConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDriver(String id, String title, MActivator activator) {
        HashMap<String, CaoDriver> hashMap = this.drivers;
        synchronized (hashMap) {
            log.t("register driver", id, title);
            this.registry.put(id, new Object[]{id, title, activator});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerActionProvider(IActionProvider actionProvider) {
        CaoActionForwarder caoActionForwarder = actionProviders;
        synchronized (caoActionForwarder) {
            log.t("register action provider", actionProvider);
            if (actionProviders.contains(actionProvider)) {
                return;
            }
            actionProviders.add(actionProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillWithActions(CaoElement element, CaoList targetList, CaoActionList actionList, Object ... initConfig) {
        CaoActionForwarder caoActionForwarder = actionProviders;
        synchronized (caoActionForwarder) {
            if (element != null) {
                element.getDriver().fillWithActions(element, targetList, actionList, initConfig);
            }
            targetList.getDriver().fillWithActions(element, targetList, actionList, initConfig);
            actionProviders.fillWithActions(element, targetList, actionList, initConfig);
        }
    }

    public MActivator getActivator(String service) throws CaoException {
        Object[] definition = this.registry.get(service);
        if (definition == null) {
            throw new CaoException(new Object[]{"Service not found: " + service});
        }
        return (MActivator)definition[2];
    }
}

