/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.cao;

import de.mhus.lib.IProperties;
import de.mhus.lib.MException;
import de.mhus.lib.cao.CaoAccess;
import de.mhus.lib.cao.CaoApplication;
import de.mhus.lib.cao.CaoConnection;
import de.mhus.lib.cao.CaoDriver;
import de.mhus.lib.cao.CaoException;
import de.mhus.lib.cao.CaoList;
import de.mhus.lib.cao.CaoMetadata;
import de.mhus.lib.cao.CaoNotSupportedException;
import de.mhus.lib.cao.CaoPolicy;
import de.mhus.lib.cao.CaoWritableElement;
import java.util.Set;

public abstract class CaoElement
extends IProperties {
    private CaoApplication app;
    protected CaoElement parent;

    protected CaoElement(CaoElement parent) throws CaoException {
        this(parent.getApplication());
        this.parent = parent;
    }

    protected CaoElement(CaoApplication app) throws CaoException {
        this.app = app;
    }

    public final CaoList getChildren() throws CaoException {
        return this.getChildren(null);
    }

    public abstract CaoList getChildren(CaoAccess var1) throws CaoException;

    public abstract boolean isNode();

    public abstract String getId() throws CaoException;

    public abstract String getName() throws CaoException;

    public abstract CaoMetadata getMetadata();

    public CaoElement getParent() {
        return this.parent;
    }

    public abstract String getString(String var1) throws CaoException;

    public final CaoList getList(String name, String ... attributes) throws CaoException {
        return this.getList(name, (CaoAccess)null, attributes);
    }

    public abstract CaoList getList(String var1, CaoAccess var2, String ... var3) throws CaoException;

    public abstract Object getObject(String var1, String ... var2) throws CaoException;

    public abstract boolean isWritable();

    public abstract CaoWritableElement getWritableNode() throws CaoException;

    public abstract void reload() throws CaoException;

    public final CaoConnection getConnection() {
        return this.app.getConnection();
    }

    public final CaoApplication getApplication() {
        return this.app;
    }

    public final CaoDriver getDriver() {
        return this.getConnection().getDriver();
    }

    public String toString() {
        try {
            return this.getName() + " (" + this.getId() + ")";
        }
        catch (CaoException caoException) {
            return super.toString();
        }
    }

    public abstract boolean lock(int var1) throws CaoException;

    public abstract boolean unlock() throws CaoException;

    public abstract boolean isLocked(boolean var1) throws CaoException;

    public abstract boolean isValid();

    public boolean equals(Object other) {
        if (other instanceof CaoElement) {
            try {
                return ((CaoElement)other).getConnection().equals(this.getConnection()) && ((CaoElement)other).getId().equals(this.getId());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return super.equals(other);
    }

    @Override
    public String getString(String name, String def) {
        String value;
        try {
            value = this.getString(name);
        }
        catch (CaoException e) {
            return def;
        }
        return value == null ? def : value;
    }

    @Override
    public Object getProperty(String name) {
        try {
            return this.getObject(name, new String[0]);
        }
        catch (CaoException caoException) {
            return null;
        }
    }

    @Override
    public boolean isProperty(String name) {
        try {
            this.getString(name);
            return true;
        }
        catch (CaoException caoException) {
            return false;
        }
    }

    @Override
    public void removeProperty(String key) throws MException {
        throw new CaoNotSupportedException(new Object[0]);
    }

    @Override
    public void setProperty(String key, Object value) throws MException {
        throw new CaoNotSupportedException(new Object[0]);
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    public CaoPolicy getAccessPolicy() throws CaoException {
        return new CaoPolicy(this, true, this.isWritable());
    }

    @Override
    public Set<String> keys() {
        return this.getMetadata().index.keySet();
    }
}

