/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.cao;

import de.mhus.lib.MActivator;
import de.mhus.lib.MSingleton;
import de.mhus.lib.MString;
import de.mhus.lib.cao.AlreadyInitialized;
import de.mhus.lib.cao.CaoActionForwarder;
import de.mhus.lib.cao.CaoActionList;
import de.mhus.lib.cao.CaoApplication;
import de.mhus.lib.cao.CaoApplicationFactory;
import de.mhus.lib.cao.CaoConnection;
import de.mhus.lib.cao.CaoElement;
import de.mhus.lib.cao.CaoException;
import de.mhus.lib.cao.CaoForm;
import de.mhus.lib.cao.CaoList;
import de.mhus.lib.cao.IActionProvider;
import de.mhus.lib.cao.util.SimpleApplicationFactory;
import de.mhus.lib.config.IConfig;
import de.mhus.lib.logging.Log;
import java.util.HashMap;
import java.util.Map;

public abstract class CaoDriver
implements IActionProvider {
    public static Log log = Log.getLog(CaoDriver.class);
    public static final String TREE_DEFAULT = "tree_default";
    public static final String CATEGORY_ID = "id";
    public static final String CATEGORY_ACL = "acl";
    public static final String APP_CONTENT = "content";
    public static final String LIST_DEFAULT = "list_default";
    public static final String ACTION_CREATE_FOLDER = "create.folder";
    public static final String ACTION_CREATE_CONTENT = "create.content";
    public static final String ACTION_IMPORT = "file.import";
    public static final String ACTION_EXPORT = "file.export";
    public static final String ACTION_CHECKOUT = "file.checkout";
    public static final String ACTION_CHECKIN = "file.checkin";
    public static final String ACTIVATOR_SERVICE = "cao.service";
    public static final String ACTION_CAP_COPY_TO = "cap.copy_to";
    public static final String ACTION_CAP_SET_TARGET = "cap.set_target";
    public static final String ACTION_DELETE = "file.delete";
    public static final String ACTION_CAP_MOVE_TO = "cap.move_to";
    public static final String ACTION_CAP_LINK_TO = "cap.link_to";
    public static final String DEFAULT_CONFIG = "cao";
    public static final String AUTO_COMPLEATION = "auto_completion";
    public static final String AUTO_COMPLETION_LITERALS = "literals";
    public static final String AUTO_COMPLETION_LABELS = "labels";
    public static final String AUTO_COMPLETION_NAME = "name";
    private Map<String, CaoApplicationFactory> applications = new HashMap<String, CaoApplicationFactory>();
    private String name;
    private IConfig config;
    private MActivator activator;
    protected CaoActionForwarder actionForwarder = new CaoActionForwarder();

    public CaoConnection createConnection(CaoForm form) throws CaoException {
        IConfig c = form.getConfig();
        if (c == null) {
            c = this.getConfig();
        }
        return this.createConnection(form.toUrl(true), c);
    }

    public abstract CaoConnection createConnection(String var1, IConfig var2) throws CaoException;

    public abstract CaoForm createConfiguration();

    public synchronized void initialize(String name, IConfig config, MActivator activator) throws AlreadyInitialized {
        if (this.name != null) {
            throw new AlreadyInitialized(new Object[]{this.getName()});
        }
        this.name = name;
        this.config = config;
        if (activator == null) {
            activator = MSingleton.instance().getActivator();
        }
        this.activator = activator;
        config = this.getConfig();
        log.t(this.getName(), "initialize", config);
        if (config != null) {
            for (IConfig capp : config.getConfigBundle("application")) {
                String aName = capp.getExtracted(AUTO_COMPLETION_NAME);
                String aClass = capp.getExtracted("class");
                if (MString.isEmpty(aName)) continue;
                try {
                    CaoApplicationFactory aFactory = null;
                    if (MString.isEmpty(aClass)) {
                        aFactory = new SimpleApplicationFactory();
                        ((SimpleApplicationFactory)aFactory).setActivator(activator);
                    } else {
                        aFactory = (CaoApplicationFactory)activator.createObject(aClass);
                    }
                    aFactory.setConfig(capp);
                    this.registerApplication(aName, aFactory);
                }
                catch (Exception e) {
                    log.e(this.getName(), aName, aClass, "can't create object", e);
                }
            }
        }
        if (this.applications.size() == 0) {
            this.initDefaultApplications();
        }
    }

    protected abstract void initDefaultApplications();

    public synchronized IConfig getConfig() {
        IConfig c;
        if (this.config == null && (c = MSingleton.instance().getConfig().getConfig(DEFAULT_CONFIG)) != null) {
            log.t(this.getName(), "loaded default config", this.config);
            this.config = c.getConfig(this.getName());
        }
        return this.config;
    }

    public void registerApplication(String name, CaoApplicationFactory factory) {
        log.d(this.getName(), "register factory", name, factory);
        factory.setName(name);
        this.applications.put(name, factory);
    }

    public CaoApplicationFactory unregisterApplication(String name) {
        log.d(this.getName(), "unregister factory", name);
        return this.applications.remove(name);
    }

    protected CaoConnection initializeConnection(CaoConnection con) {
        this.createApplications(con);
        return con;
    }

    private void createApplications(CaoConnection con) {
        block6: {
            IConfig c = con.getConfig();
            if (c == null) break block6;
            IConfig[] bundle = c.getConfigBundle("load_application");
            if (bundle.length == 0) {
                for (Map.Entry<String, CaoApplicationFactory> factory : this.applications.entrySet()) {
                    log.t(this.getName(), "Load Application", factory.getKey());
                    CaoApplication app = factory.getValue().create(con);
                    if (app == null) continue;
                    log.t(this.getName(), "Register Application", factory.getKey());
                    this.putApplication(con, factory.getKey(), app);
                }
            } else {
                for (IConfig cload : bundle) {
                    String aName = cload.getExtracted(AUTO_COMPLETION_NAME);
                    try {
                        log.t(this.getName(), "Load Application", aName);
                        CaoApplicationFactory factory = this.applications.get(aName);
                        CaoApplication app = factory.create(con, cload);
                        if (app == null) continue;
                        String alias = cload.getExtracted("alias", aName);
                        log.t(this.getName(), "Register Application", alias, aName);
                        this.putApplication(con, alias, app);
                    }
                    catch (Throwable t) {
                        log.e(this.getName(), "loading application", aName, t);
                    }
                }
            }
        }
    }

    protected void putApplication(CaoConnection con, String name, CaoApplication app) {
        con.applications.put(name, app);
    }

    public String getName() {
        return this.name;
    }

    public MActivator getActivator() {
        return this.activator;
    }

    @Override
    public void fillWithActions(CaoElement element, CaoList targetList, CaoActionList actionList, Object ... initConfig) {
        try {
            if (element == null) {
                for (CaoElement ele : targetList.getElements()) {
                    ele.getApplication().fillWithActions(ele, targetList, actionList, initConfig);
                }
            } else {
                element.getApplication().fillWithActions(element, targetList, actionList, initConfig);
            }
        }
        catch (Exception e) {
            log.t(e);
        }
        this.actionForwarder.fillWithActions(element, targetList, actionList, initConfig);
    }
}

