/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.cao;

import de.mhus.lib.MActivator;
import de.mhus.lib.MEventHandler;
import de.mhus.lib.cao.CaoAccess;
import de.mhus.lib.cao.CaoActionList;
import de.mhus.lib.cao.CaoApplication;
import de.mhus.lib.cao.CaoDriver;
import de.mhus.lib.cao.CaoElement;
import de.mhus.lib.cao.CaoException;
import de.mhus.lib.cao.CaoList;
import de.mhus.lib.cao.CaoObserver;
import de.mhus.lib.cao.CaoPrincipal;
import de.mhus.lib.cao.CaoUser;
import de.mhus.lib.cao.IActionProvider;
import de.mhus.lib.cao.ICaoChangeListener;
import de.mhus.lib.cao.ObjectNotFoundException;
import de.mhus.lib.config.IConfig;
import de.mhus.lib.logging.Log;
import java.util.HashMap;
import java.util.Map;

public abstract class CaoConnection
implements CaoAccess,
IActionProvider {
    private CaoDriver driver;
    protected HashMap<String, CaoApplication> applications = new HashMap();
    private Map<String, Object> conext = new HashMap<String, Object>();
    private static Log log = Log.getLog(CaoConnection.class);
    protected CaoUser user;
    private ChangedHandler changedHandler = new ChangedHandler();
    private IConfig config;
    protected MActivator activator;

    public CaoConnection(CaoDriver driver, IConfig config, MActivator activator) {
        this.driver = driver;
        this.config = config;
        this.activator = activator;
        driver.initializeConnection(this);
    }

    public CaoConnection(CaoDriver driver, IConfig config) {
        this(driver, config, driver.getActivator());
    }

    protected void setUser(CaoUser user) {
        this.user = user;
    }

    public boolean hasApplication(String name) {
        return this.applications.containsKey(name);
    }

    public final CaoApplication getApplication(String name) throws CaoException {
        return this.getApplication(null, name);
    }

    public CaoApplication getApplication(CaoAccess access, String name) throws CaoException {
        CaoApplication app = this.applications.get(name);
        if (app == null) {
            throw new ObjectNotFoundException("Application: " + name);
        }
        return app;
    }

    public final CaoDriver getDriver() {
        return this.driver;
    }

    public Map<String, Object> getContext() {
        return this.conext;
    }

    public void fireElementUpdated(String id) {
        if (this.changedHandler == null) {
            return;
        }
        this.changedHandler.fireElementUpdated(id);
    }

    public void fireElementDeleted(String id) {
        if (this.changedHandler == null) {
            return;
        }
        this.changedHandler.fireElementDeleted(id);
    }

    public void fireElementCreated(String id) {
        if (this.changedHandler == null) {
            return;
        }
        this.changedHandler.fireElementCreated(id);
    }

    public void fireElementLink(String parentId, String id) {
        if (this.changedHandler == null) {
            return;
        }
        this.changedHandler.fireElementLink(parentId, id);
    }

    public void fireElementUnlink(String parentId, String id) {
        if (this.changedHandler == null) {
            return;
        }
        this.changedHandler.fireElementUnlink(parentId, id);
    }

    public void fireElementStructurChanged(String id) {
        if (this.changedHandler == null) {
            return;
        }
        this.changedHandler.fireElementStructurChanged(id);
    }

    public void fireDisconnected() {
        if (this.changedHandler == null) {
            return;
        }
        this.changedHandler.fireDisconnected();
    }

    public CaoObserver createObserver() {
        CaoObserver observer = new CaoObserver(this);
        this.changedHandler.registerWeak(observer);
        return observer;
    }

    @Override
    public CaoPrincipal getCurrentUser() {
        return this.user;
    }

    public IConfig getConfig() {
        if (this.config == null) {
            return this.getDriver().getConfig();
        }
        return this.config;
    }

    public void disconnect() {
        if (!this.isValid()) {
            return;
        }
        this.doDisconnect();
        this.fireDisconnected();
        this.changedHandler = null;
    }

    protected abstract void doDisconnect();

    public abstract boolean isValid();

    public MActivator getActivator() {
        return this.activator;
    }

    @Override
    public void fillWithActions(CaoElement element, CaoList targetList, CaoActionList actionList, Object ... initConfig) {
    }

    private class ChangedHandler
    extends MEventHandler<ICaoChangeListener> {
        private ChangedHandler() {
        }

        public void fireDisconnected() {
            for (ICaoChangeListener item : this.getListeners()) {
                try {
                    item.disconnected(CaoConnection.this);
                }
                catch (Throwable t) {
                    log.debug(t);
                }
            }
        }

        public void fireElementUpdated(String id) {
            for (ICaoChangeListener item : this.getListeners()) {
                try {
                    item.elementUpdated(CaoConnection.this, id);
                }
                catch (Throwable t) {
                    log.debug(t);
                }
            }
        }

        public void fireElementLink(String parentId, String id) {
            for (Object item : this.getListenersArray()) {
                try {
                    ((ICaoChangeListener)item).elementLink(CaoConnection.this, parentId, id);
                }
                catch (Throwable t) {
                    log.debug(t);
                }
            }
        }

        public void fireElementUnlink(String parentId, String id) {
            for (Object item : this.getListenersArray()) {
                try {
                    ((ICaoChangeListener)item).elementUnlink(CaoConnection.this, parentId, id);
                }
                catch (Throwable t) {
                    log.debug(t);
                }
            }
        }

        public void fireElementCreated(String id) {
            for (Object item : this.getListenersArray()) {
                try {
                    ((ICaoChangeListener)item).elementCreated(CaoConnection.this, id);
                }
                catch (Throwable t) {
                    log.debug(t);
                }
            }
        }

        public void fireElementDeleted(String id) {
            for (Object item : this.getListenersArray()) {
                try {
                    ((ICaoChangeListener)item).elementDeleted(CaoConnection.this, id);
                }
                catch (Throwable t) {
                    log.debug(t);
                }
            }
        }

        public void fireElementStructurChanged(String id) {
            for (Object item : this.getListenersArray()) {
                try {
                    ((ICaoChangeListener)item).elementStructurChanged(CaoConnection.this, id);
                }
                catch (Throwable t) {
                    log.debug(t);
                }
            }
        }
    }
}

