/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.cao;

import de.mhus.lib.cao.CaoApplication;
import de.mhus.lib.cao.CaoConnection;
import de.mhus.lib.cao.CaoException;
import de.mhus.lib.cao.CaoForm;
import de.mhus.lib.config.IConfig;
import de.mhus.lib.logging.Log;

public abstract class CaoApplicationFactory {
    private static Log log = Log.getLog(CaoApplicationFactory.class);
    protected IConfig config;
    private String name;

    public abstract CaoForm createConfiguration();

    public CaoApplication create(CaoConnection con) {
        IConfig appConfig;
        IConfig c = this.config;
        if (c == null) {
            c = con.getDriver().getConfig();
        }
        if (c != null && (appConfig = c.getConfig(this.getName())) != null) {
            try {
                return this.create(con, appConfig);
            }
            catch (CaoException e) {
                log.e(con.getDriver().getName(), this.getName(), e);
            }
        }
        log.i("application not created", con.getDriver().getName(), this.getName());
        return null;
    }

    protected abstract CaoApplication create(CaoConnection var1, IConfig var2) throws CaoException;

    public void setConfig(IConfig config) {
        this.config = config;
    }

    void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }
}

