/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.adb.util;

import de.mhus.lib.MException;
import de.mhus.lib.adb.DbManager;
import de.mhus.lib.adb.util.Property;

public class DbProperties {
    private DbManager manager;
    private String registryName;
    private String dump;

    public DbProperties(DbManager manager, String registryName) {
        this.manager = manager;
        this.registryName = registryName;
    }

    public String get(String key) throws MException {
        Property prop = (Property)this.manager.getObject(this.registryName, key);
        if (prop == null) {
            return null;
        }
        return prop.getValue();
    }

    public String set(String key, String value) throws MException {
        Property prop = (Property)this.manager.getObject(this.registryName, key);
        if (prop == null) {
            prop = new Property();
            prop.setKey(key);
            prop.setValue(value);
            this.manager.createObject(this.registryName, (Object)prop);
            return null;
        }
        String oldValue = prop.getValue();
        prop.setValue(value);
        this.manager.saveObject(this.registryName, (Object)prop);
        this.dump = null;
        return oldValue;
    }

    public String remove(String key) throws MException {
        Property prop = (Property)this.manager.getObject(this.registryName, key);
        if (prop == null) {
            return null;
        }
        String oldValue = prop.getValue();
        this.manager.removeObject(this.registryName, (Object)prop);
        this.dump = null;
        return oldValue;
    }
}

