/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.adb.model;

import de.mhus.lib.adb.annotations.DbIndex;
import de.mhus.lib.adb.annotations.DbPersistent;
import de.mhus.lib.adb.annotations.DbPrimaryKey;
import de.mhus.lib.adb.model.Field;
import de.mhus.lib.adb.model.Table;
import de.mhus.lib.config.IConfig;
import de.mhus.lib.config.MConfigFactory;
import java.lang.reflect.Method;
import java.util.LinkedList;

public class TableAnnotations
extends Table {
    @Override
    protected void parseFields() throws Exception {
        for (Method m : this.getMethods(this.clazz)) {
            boolean v;
            DbPrimaryKey pk = m.getAnnotation(DbPrimaryKey.class);
            DbPersistent p = m.getAnnotation(DbPersistent.class);
            DbIndex idx = m.getAnnotation(DbIndex.class);
            if (pk == null && p == null) continue;
            String mName = m.getName();
            Method getter = null;
            Method setter = null;
            if (mName.startsWith("get")) {
                mName = mName.substring(3);
                getter = m;
                setter = this.clazz.getMethod("set" + mName, getter.getReturnType());
            } else if (mName.startsWith("set")) {
                mName = mName.substring(3);
                setter = m;
                try {
                    getter = this.clazz.getMethod("get" + mName, new Class[0]);
                }
                catch (NoSuchMethodException nsme) {
                    getter = this.clazz.getMethod("is" + mName, new Class[0]);
                }
            } else if (mName.startsWith("is")) {
                mName = mName.substring(2);
                getter = m;
                setter = this.clazz.getMethod("set" + mName, getter.getReturnType());
            } else {
                this.log().d("field is not a getter/setter" + mName);
                continue;
            }
            if (getter == null) {
                this.log().d("getter not found", mName);
                continue;
            }
            if (setter == null) {
                this.log().d("setter not found", mName);
                continue;
            }
            Class<?> ret = getter.getReturnType();
            if (ret == Void.TYPE) {
                this.log().d("Value type is void - ignore");
                continue;
            }
            if (this.fIndex.containsKey(mName.toLowerCase())) {
                this.log().d("field already defined", mName);
                continue;
            }
            this.log().t("field", mName);
            IConfig attr = MConfigFactory.getInstance().toConfig(this.toAttributes(p));
            boolean bl = v = p != null && p.virtual();
            if (this.getField(mName) != null) {
                this.log().t("double field definition", mName);
                continue;
            }
            Field field = this.manager.getSchema().createField(this.manager, this, mName, pk != null, v, setter, getter, ret, attr, null);
            if (field != null) {
                this.addField(field);
            }
            if (idx == null || !field.isPersistent()) continue;
            this.addToIndex(idx.value(), field);
        }
    }

    private LinkedList<Method> getMethods(Class<?> clazz) {
        LinkedList<Method> out = new LinkedList<Method>();
        do {
            for (Method m : clazz.getMethods()) {
                out.add(m);
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return out;
    }
}

