/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.adb.model;

import de.mhus.lib.MException;
import de.mhus.lib.MString;
import de.mhus.lib.adb.DbManager;
import de.mhus.lib.adb.DbSchema;
import de.mhus.lib.adb.annotations.DbPersistent;
import de.mhus.lib.adb.annotations.DbTable;
import de.mhus.lib.adb.model.Feature;
import de.mhus.lib.adb.model.Field;
import de.mhus.lib.config.HashConfig;
import de.mhus.lib.config.IConfig;
import de.mhus.lib.config.MConfigFactory;
import de.mhus.lib.lang.MObject;
import de.mhus.lib.lang.Raw;
import de.mhus.lib.sql.DbConnection;
import de.mhus.lib.sql.DbPrepared;
import de.mhus.lib.sql.DbResult;
import de.mhus.lib.sql.Dialect;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public abstract class Table
extends MObject {
    protected Class<?> clazz;
    protected String registryName;
    protected DbManager manager;
    protected String name;
    protected String tableNameOrg;
    protected DbSchema schema;
    protected String tableName;
    protected HashMap<String, Field> fIndex = new HashMap();
    protected LinkedList<Field> fList = new LinkedList();
    private HashMap<String, LinkedList<Field>> iIdx = new HashMap();
    protected LinkedList<Field> pk = new LinkedList();
    private DbPrepared sqlPrimary;
    private DbPrepared sqlInsert;
    private DbPrepared sqlUpdate;
    private DbPrepared sqlRemove;
    private LinkedList<Feature> features = new LinkedList();
    protected IConfig attributes;

    public void init(DbManager manager, Class<?> clazz, String registryName, String tableName) {
        this.manager = manager;
        this.schema = manager.getSchema();
        this.clazz = clazz;
        this.registryName = registryName;
        this.tableName = tableName;
    }

    public void initDatabase(DbConnection con) throws Exception {
        DbTable table = this.clazz.getAnnotation(DbTable.class);
        this.name = this.tableName != null ? this.tableName : (table == null || MString.isEmptyTrim(table.tableName()) ? this.clazz.getSimpleName() : table.tableName());
        this.attributes = table != null && !MString.isEmptyTrim(table.attributes()) ? MConfigFactory.getInstance().toConfig(table.attributes()) : new HashConfig();
        this.tableNameOrg = this.schema.getTableName(this.name);
        this.tableName = this.manager.getPool().getDialect().normalizeTableName(this.tableNameOrg);
        this.log().t("new table", this.name, this.tableName);
        this.parseFields();
        if (table != null && !MString.isEmptyTrim(table.features())) {
            for (String featureName : MString.split(table.features(), ",")) {
                Feature feature = this.manager.getSchema().createFeature(this.manager, this, featureName);
                if (feature == null) continue;
                this.features.add(feature);
            }
        }
        this.createTable(con);
        this.postInit();
    }

    protected abstract void parseFields() throws Exception;

    protected void addToIndex(String list, Field field) {
        for (String nr : MString.split(list, ",")) {
            LinkedList<Field> list2 = this.iIdx.get(nr);
            if (list2 == null) {
                list2 = new LinkedList();
                this.iIdx.put(nr, list2);
            }
            list2.add(field);
        }
    }

    protected void addField(Field field) {
        field.table = this;
        this.fIndex.put(field.createName, field);
        this.fList.add(field);
        if (field.isPrimary && field.isPersistent()) {
            this.pk.add(field);
        }
    }

    public void fillNameMapping(HashMap<String, Object> nameMapping) throws Exception {
        nameMapping.put("db." + this.name, new Raw(this.tableName));
        for (Field f : this.fList) {
            f.fillNameMapping(nameMapping);
        }
    }

    public void prepareCreate(Object object) throws Exception {
        for (Field f : this.fList) {
            f.prepareCreate(object);
        }
    }

    public void createObject(DbConnection con, Object object) throws Exception {
        for (Feature f : this.features) {
            f.createObject(con, object);
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        for (Field f : this.fList) {
            attributes.put(f.name, f.getFromTarget(object));
        }
        this.sqlInsert.getStatement(con).execute(attributes);
    }

    public void saveObject(DbConnection con, Object object) throws Exception {
        for (Feature f : this.features) {
            f.saveObject(con, object);
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        for (Field f : this.fList) {
            attributes.put(f.name, f.getFromTarget(object));
        }
        int c = this.sqlUpdate.getStatement(con).executeUpdate(attributes);
        if (c != 1) {
            throw new MException(new Object[]{"update failed, updated objects " + c});
        }
    }

    protected void postInit() throws MException {
        Collections.sort(this.pk, new Comparator<Field>(){

            @Override
            public int compare(Field o1, Field o2) {
                return o1.name.compareTo(o2.name);
            }
        });
        String sql = "SELECT * FROM " + this.tableName + " WHERE ";
        int nr = 0;
        for (Field f : this.pk) {
            sql = sql + (nr > 0 ? " AND " : "") + f.name + "=$" + nr + "$";
            ++nr;
        }
        this.sqlPrimary = this.manager.getPool().createStatement(sql);
        sql = "INSERT INTO " + this.tableName + " (";
        nr = 0;
        for (Field f : this.fList) {
            if (!f.isPersistent()) continue;
            if (nr > 0) {
                sql = sql + ",";
            }
            sql = sql + f.name;
            ++nr;
        }
        sql = sql + ") VALUES (";
        nr = 0;
        for (Field f : this.fList) {
            if (!f.isPersistent()) continue;
            if (nr > 0) {
                sql = sql + ",";
            }
            sql = sql + "$" + f.name + "$";
            ++nr;
        }
        sql = sql + ")";
        this.sqlInsert = this.manager.getPool().createStatement(sql);
        sql = "UPDATE " + this.tableName + " SET ";
        nr = 0;
        for (Field f : this.fList) {
            if (f.isPrimary || !f.isPersistent()) continue;
            if (nr > 0) {
                sql = sql + ",";
            }
            sql = sql + f.name + "=$" + f.name + "$";
            ++nr;
        }
        sql = sql + " WHERE ";
        nr = 0;
        for (Field f : this.pk) {
            sql = sql + (nr > 0 ? " AND " : "") + f.name + "=$" + f.name + "$";
            ++nr;
        }
        this.sqlUpdate = this.manager.getPool().createStatement(sql);
        sql = "DELETE FROM " + this.tableName + " WHERE ";
        nr = 0;
        for (Field f : this.pk) {
            sql = sql + (nr > 0 ? " AND " : "") + f.name + "=$" + f.name + "$";
            ++nr;
        }
        this.sqlRemove = this.manager.getPool().createStatement(sql);
    }

    public Object getObject(DbConnection con, Object[] keys) throws Exception {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        int nr = 0;
        for (Object object : keys) {
            attributes.put(String.valueOf(nr), object);
            ++nr;
        }
        DbResult ret = this.sqlPrimary.getStatement(con).executeQuery(attributes);
        if (!ret.next()) {
            ret.close();
            return null;
        }
        for (Feature f : this.features) {
            f.getObject(con, ret);
        }
        Object obj = this.schema.createObject(this.clazz, this.registryName, ret, this.manager);
        for (Field field : this.fList) {
            field.setToTarget(ret, obj);
        }
        for (Feature feature : this.features) {
            feature.getObject(con, obj);
        }
        return obj;
    }

    public void fillObject(Object obj, DbConnection con, DbResult res) throws Exception {
        for (Feature feature : this.features) {
            feature.fillObject(obj, con, res);
        }
        for (Field field : this.fList) {
            field.setToTarget(res, obj);
        }
    }

    public Object fillObject(DbConnection con, Object obj, Object[] keys) throws Exception {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        int nr = 0;
        for (Object key : keys) {
            attributes.put(String.valueOf(nr), key);
            ++nr;
        }
        DbResult ret = this.sqlPrimary.getStatement(con).executeQuery(attributes);
        if (!ret.next()) {
            ret.close();
            return null;
        }
        for (Feature f : this.features) {
            f.fillObject(obj, con, ret);
        }
        for (Field f : this.fList) {
            f.setToTarget(ret, obj);
        }
        return obj;
    }

    public void createTable(DbConnection con) throws Exception {
        HashConfig cstr = new HashConfig();
        IConfig ctable = cstr.createConfig("table");
        ctable.setProperty("name", this.tableNameOrg);
        LinkedList<String> pk = new LinkedList<String>();
        for (Field field : this.fList) {
            IConfig cfield = ctable.createConfig("field");
            cfield.setProperty("name", field.createName);
            cfield.setProperty("type", field.retDbType);
            cfield.setProperty("size", String.valueOf(field.size));
            cfield.setProperty("default", field.defValue);
            cfield.setProperty("notnull", field.nullable ? "no" : "yes");
            LinkedList<String> cat = new LinkedList<String>();
            if (!field.isPersistent()) {
                cat.add("[virtual]");
            }
            if (field.isPrimary) {
                cat.add("[pk]");
            }
            if (field.ret.isEnum()) {
                cat.add("[enum]");
            }
            cfield.setProperty("category", MString.join(cat.iterator(), ","));
            if (!field.isPrimary || !field.isPersistent()) continue;
            pk.add(field.createName);
        }
        if (pk.size() > 0) {
            String pkNames = MString.join(pk.iterator(), ",");
            ctable.setProperty("primary_key", pkNames);
        }
        for (Map.Entry entry : this.iIdx.entrySet()) {
            IConfig cindex = cstr.createConfig("index");
            String n = (String)entry.getKey();
            if (n.startsWith("u")) {
                cindex.setString("type", "unique");
            }
            cindex.setString("name", "idx_" + n);
            cindex.setString("table", this.tableNameOrg);
            StringBuffer fields = new StringBuffer();
            for (Field field : (LinkedList)entry.getValue()) {
                if (fields.length() > 0) {
                    fields.append(",");
                }
                fields.append(field.createName);
            }
            cindex.setString("fields", fields.toString());
        }
        this.manager.getPool().getDialect().createStructure(cstr, con, this.manager.getCaoMetadata());
    }

    public void removeObject(DbConnection con, Object object) throws Exception {
        for (Feature f : this.features) {
            f.removeObject(con, object);
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        for (Field f : this.pk) {
            attributes.put(f.name, f.getFromTarget(object));
        }
        this.sqlRemove.getStatement(con).execute(attributes);
    }

    public String getRegistryName() {
        return this.registryName;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public String getTableName() {
        return this.tableNameOrg;
    }

    public Field getField(String fName) {
        return this.fIndex.get(fName);
    }

    public List<Field> getPrimaryKeys() {
        return this.pk;
    }

    public String toAttributes(DbPersistent pa) {
        String more;
        String type;
        if (pa == null) {
            return "";
        }
        StringBuffer out = new StringBuffer();
        out.append("size=").append(pa.size());
        if (pa.auto_id()) {
            out.append("&auto_id=true");
        }
        if (!pa.nullable()) {
            out.append("&nullable=false");
        }
        if (!MString.isEmpty(type = Dialect.typeEnumToString(pa.type()))) {
            out.append("&type=").append(type);
        }
        if (!MString.isEmpty(more = pa.more())) {
            out.append("&").append(more);
        }
        return out.toString();
    }

    protected String getDbRetType(Class<?> ret) {
        String rt = Dialect.TYPE.BLOB.name();
        if (ret == Integer.TYPE) {
            rt = Dialect.TYPE.INT.name();
        } else if (ret == Long.TYPE) {
            rt = Dialect.TYPE.LONG.name();
        } else if (ret == Boolean.TYPE) {
            rt = Dialect.TYPE.BOOL.name();
        } else if (ret == Double.TYPE) {
            rt = Dialect.TYPE.DOUBLE.name();
        } else if (ret == Float.TYPE) {
            rt = Dialect.TYPE.FLOAT.name();
        } else if (ret == String.class) {
            rt = Dialect.TYPE.STRING.name();
        } else if (ret == Date.class || ret == Calendar.class) {
            rt = Dialect.TYPE.DATETIME.name();
        } else if (ret == UUID.class) {
            rt = Dialect.TYPE.UUID.name();
        } else if (ret.isEnum()) {
            rt = Dialect.TYPE.INT.name();
        }
        return rt;
    }

    public String getName() {
        return this.name;
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public IConfig getAttributes() {
        return this.attributes;
    }
}

