/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.adb.model;

import de.mhus.lib.MDate;
import de.mhus.lib.MException;
import de.mhus.lib.adb.DbDynamic;
import de.mhus.lib.adb.DbManager;
import de.mhus.lib.adb.model.Field;
import de.mhus.lib.adb.model.Table;
import de.mhus.lib.config.IConfig;
import de.mhus.lib.lang.Raw;
import de.mhus.lib.sql.DbResult;
import de.mhus.lib.sql.Dialect;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;

public class FieldPersistent
extends Field {
    private DbManager manager;

    public FieldPersistent(DbManager manager, Table table, String name, boolean isPrimary, Method setter, Method getter, Class<?> ret, IConfig attr2, DbDynamic.Field dynamicField) {
        this.manager = manager;
        this.table = table;
        this.nameOrg = name;
        this.name = manager.getPool().getDialect().normalizeColumnName(this.nameOrg.toLowerCase());
        this.createName = name.toLowerCase();
        this.methodName = name;
        this.isPrimary = isPrimary;
        this.setter = setter;
        this.getter = getter;
        this.ret = ret;
        this.attr = attr2;
        this.dynamicField = dynamicField;
        this.init();
    }

    protected void init() {
        this.retDbType = this.attr.getExtracted("type", this.table.getDbRetType(this.ret)).toUpperCase();
        this.autoId = this.attr.getBoolean("auto_id", false);
        this.size = this.attr.getInt("size", this.size);
        this.defValue = this.attr.getString("default", null);
        this.nullable = this.attr.getBoolean("nullable", true);
        if (this.isPrimary) {
            this.nullable = false;
        }
    }

    @Override
    public void fillNameMapping(HashMap<String, Object> nameMapping) {
        nameMapping.put("db." + this.table.getName() + "." + this.methodName, new Raw(this.name));
        if (this.ret.isEnum()) {
            int cnt = 0;
            for (Object c : this.ret.getEnumConstants()) {
                nameMapping.put("db." + this.table.name + "." + this.methodName + "." + c, cnt);
                ++cnt;
            }
        }
    }

    @Override
    public void prepareCreate(Object obj) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, MException {
        if (this.autoId) {
            if (this.ret == UUID.class) {
                UUID uuid = UUID.randomUUID();
                this.set(obj, uuid);
            } else if (this.ret == String.class) {
                UUID uuid = UUID.randomUUID();
                this.set(obj, uuid.toString());
            } else if (this.ret == Long.TYPE) {
                long id = this.manager.getSchema().getUniqueId(this.table, this, obj, this.name, this.manager);
                this.set(obj, id);
            } else {
                this.log().i("can't set uuid to object", this.name);
            }
        }
    }

    @Override
    public Object getFromTarget(Object obj) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, IOException {
        Object out = this.get(obj);
        if (this.retDbType.equals(Dialect.TYPE.BLOB.name())) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(os);
            oos.writeObject(out);
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            return is;
        }
        return out;
    }

    @Override
    public void setToTarget(DbResult res, Object obj) throws Exception {
        if (this.retDbType.equals(Dialect.TYPE.INT.name())) {
            this.set(obj, res.getInt(this.name));
        } else if (this.retDbType.equals(Dialect.TYPE.LONG.name())) {
            this.set(obj, res.getLong(this.name));
        } else if (this.retDbType.equals(Dialect.TYPE.BOOL.name())) {
            this.set(obj, res.getBoolean(this.name));
        } else if (this.retDbType.equals(Dialect.TYPE.DATETIME.name())) {
            if (this.ret == Date.class) {
                this.set(obj, res.getDate(this.name));
            } else {
                this.set(obj, new MDate(res.getDate(this.name)).toCalendar());
            }
        } else if (this.retDbType.equals(Dialect.TYPE.DOUBLE.name())) {
            this.set(obj, res.getDouble(this.name));
        } else if (this.retDbType.equals(Dialect.TYPE.FLOAT.name())) {
            this.set(obj, Float.valueOf(res.getFloat(this.name)));
        } else if (this.retDbType.equals(Dialect.TYPE.STRING.name())) {
            this.set(obj, res.getString(this.name));
        } else if (this.retDbType.equals(Dialect.TYPE.UUID.name())) {
            String o = res.getString(this.name);
            if (o == null) {
                this.set(obj, null);
            } else {
                try {
                    this.set(obj, UUID.fromString(o));
                }
                catch (Throwable t) {
                    this.log().d("uuid", this.name, o, t);
                    this.set(obj, null);
                }
            }
        } else if (this.retDbType.equals(Dialect.TYPE.BLOB.name())) {
            InputStream st = res.getBinaryStream(this.name);
            if (st != null) {
                ObjectInputStream ois = new ObjectInputStream(st);
                Object o = ois.readObject();
                this.set(obj, o);
            } else {
                this.set(obj, null);
            }
        } else {
            this.log().d("can't set to target ", this.name, this.retDbType);
        }
    }

    @Override
    public boolean isPersistent() {
        return true;
    }
}

