/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.adb.model;

import de.mhus.lib.MCast;
import de.mhus.lib.MException;
import de.mhus.lib.adb.DbDynamic;
import de.mhus.lib.adb.model.Feature;
import de.mhus.lib.adb.model.Table;
import de.mhus.lib.config.IConfig;
import de.mhus.lib.lang.MObject;
import de.mhus.lib.sql.DbResult;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;

public abstract class Field
extends MObject {
    protected boolean isPrimary;
    protected String name;
    protected String nameOrg;
    protected String createName;
    protected Method setter;
    protected Method getter;
    protected Table table;
    protected boolean nullable = true;
    protected String defValue = null;
    protected int size = 200;
    protected Class<?> ret;
    protected String retDbType;
    protected String methodName;
    protected boolean autoId;
    protected IConfig attr;
    protected DbDynamic.Field dynamicField;

    public abstract void prepareCreate(Object var1) throws Exception;

    public abstract boolean isPersistent();

    public abstract Object getFromTarget(Object var1) throws Exception;

    public abstract void setToTarget(DbResult var1, Object var2) throws Exception;

    public abstract void fillNameMapping(HashMap<String, Object> var1);

    public void set(Object obj, Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, MException {
        if (this.ret.isEnum()) {
            int index = -1;
            if (value == null) {
                index = MCast.toint(this.defValue, -1);
            } else if (value instanceof Number) {
                index = ((Number)value).intValue();
            }
            ?[] values = this.ret.getEnumConstants();
            if (index < 0 || index >= values.length) {
                throw new MException("index not found in enum", this.ret.getName());
            }
            value = values[index];
        }
        for (Feature f : this.table.getFeatures()) {
            value = f.set(obj, this, value);
        }
        if (this.dynamicField != null && obj instanceof DbDynamic) {
            ((DbDynamic)obj).setValue(this.dynamicField, value);
        } else {
            this.setter.invoke(obj, value);
        }
    }

    public Object get(Object obj) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object val = null;
        val = this.dynamicField != null && obj instanceof DbDynamic ? ((DbDynamic)obj).getValue(this.dynamicField) : this.getter.invoke(obj, new Object[0]);
        for (Feature f : this.table.getFeatures()) {
            val = f.get(obj, this, val);
        }
        return val;
    }

    public IConfig getAttributes() {
        return this.attr;
    }

    public int getSize() {
        return this.size;
    }
}

